/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
* TProtectionKey declaration
*
*/


/**
 @file 
 @publishedAll
 @released
*/
#ifndef PROTECTIONKEY_H
#define PROTECTIONKEY_H

#include <s32strm.h>

namespace AuthServer
{

/**
 * CProtectionKey is a cryptographic key that is assigned to an
 * identity. Protection keys are used by authentication clients 
 * to protect data that only the associated identity should be 
 * able to access. Protection keys are generated by the AuthServer
 * when a new identity is created.
 */
NONSHARABLE_CLASS(CProtectionKey) : public CBase
	{
public:
	virtual ~CProtectionKey();
	

	IMPORT_C static CProtectionKey* NewL(TInt aKeySize);	
	IMPORT_C static CProtectionKey* NewLC(TInt aKeySize);
	IMPORT_C static CProtectionKey* NewL(HBufC8* aKeyData);
	IMPORT_C static CProtectionKey* NewLC(HBufC8* aKeyData);

	IMPORT_C CProtectionKey* ClientKeyL(TInt aClientUid) const;
	IMPORT_C TPtrC8 KeyData() const;
	
private:
	CProtectionKey();
	void ConstructL(TInt aKeySize);
	void ConstructL(HBufC8* aKeyData);

	HBufC8* iKeyData;
	};

}

#endif // PROTECTIONKEY_H
