/*
 * Summary: incomplete XML Schemas structure implementation
 * Description: interface to the XML Schemas handling and schema validity
 *              checking, it is incomplete right now.
 *
 * Copy: See Copyright for the status of this software.
 *
 * Author: Daniel Veillard
 * Portion Copyright  2009 Nokia Corporation and/or its subsidiary(-ies). All rights reserved. 
 */

/** @file
@publishedAll
@released
*/

#ifndef XML_SCHEMA_H
#define XML_SCHEMA_H

#include <stdapis/libxml2/libxml2_xmlversion.h>

#ifdef LIBXML_SCHEMAS_ENABLED

#include <stdapis/libxml2/libxml2_tree.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
    XML_SCHEMAS_ERR_OK          = 0,
    XML_SCHEMAS_ERR_NOROOT      = 1,
    XML_SCHEMAS_ERR_UNDECLAREDELEM,
    XML_SCHEMAS_ERR_NOTTOPLEVEL,
    XML_SCHEMAS_ERR_MISSING,
    XML_SCHEMAS_ERR_WRONGELEM,
    XML_SCHEMAS_ERR_NOTYPE,
    XML_SCHEMAS_ERR_NOROLLBACK,
    XML_SCHEMAS_ERR_ISABSTRACT,
    XML_SCHEMAS_ERR_NOTEMPTY,
    XML_SCHEMAS_ERR_ELEMCONT,
    XML_SCHEMAS_ERR_HAVEDEFAULT,
    XML_SCHEMAS_ERR_NOTNILLABLE,
    XML_SCHEMAS_ERR_EXTRACONTENT,
    XML_SCHEMAS_ERR_INVALIDATTR,
    XML_SCHEMAS_ERR_INVALIDELEM,
    XML_SCHEMAS_ERR_NOTDETERMINIST,
    XML_SCHEMAS_ERR_CONSTRUCT,
    XML_SCHEMAS_ERR_INTERNAL,
    XML_SCHEMAS_ERR_NOTSIMPLE,
    XML_SCHEMAS_ERR_ATTRUNKNOWN,
    XML_SCHEMAS_ERR_ATTRINVALID,
    XML_SCHEMAS_ERR_VALUE,
    XML_SCHEMAS_ERR_FACET,
    XML_SCHEMAS_ERR_,
    XML_SCHEMAS_ERR_XXX
} xmlSchemaValidError;


/**
 * The schemas related types are kept internal
 */
typedef struct _xmlSchema xmlSchema;
typedef xmlSchema *xmlSchemaPtr;

/**
 * A schemas validation context
 */
typedef void (*xmlSchemaValidityErrorFunc) (void *ctx, const char *msg, ...);
typedef void (*xmlSchemaValidityWarningFunc) (void *ctx, const char *msg, ...);

typedef struct _xmlSchemaParserCtxt xmlSchemaParserCtxt;
typedef xmlSchemaParserCtxt *xmlSchemaParserCtxtPtr;

typedef struct _xmlSchemaValidCtxt xmlSchemaValidCtxt;
typedef xmlSchemaValidCtxt *xmlSchemaValidCtxtPtr;

/*
 * Interfaces for parsing.
 */
XMLPUBFUN xmlSchemaParserCtxtPtr XMLCALL
            xmlSchemaNewParserCtxt      (const char *URL);
XMLPUBFUN xmlSchemaParserCtxtPtr XMLCALL
            xmlSchemaNewMemParserCtxt   (const char *buffer,
                                         int size);
XMLPUBFUN xmlSchemaParserCtxtPtr XMLCALL
            xmlSchemaNewDocParserCtxt   (xmlDocPtr doc);
XMLPUBFUN void XMLCALL
            xmlSchemaFreeParserCtxt     (xmlSchemaParserCtxtPtr ctxt);
XMLPUBFUN void XMLCALL
            xmlSchemaSetParserErrors    (xmlSchemaParserCtxtPtr ctxt,
                                         xmlSchemaValidityErrorFunc err,
                                         xmlSchemaValidityWarningFunc warn,
                                         void *ctx);
XMLPUBFUN xmlSchemaPtr XMLCALL
            xmlSchemaParse              (xmlSchemaParserCtxtPtr ctxt);
XMLPUBFUN void XMLCALL
            xmlSchemaFree               (xmlSchemaPtr schema);
#ifdef LIBXML_OUTPUT_ENABLED
XMLPUBFUN void XMLCALL
            xmlSchemaDump               (FILE *output,
                                         xmlSchemaPtr schema);
#endif /* LIBXML_OUTPUT_ENABLED */
/*
 * Interfaces for validating
 */
XMLPUBFUN void XMLCALL
            xmlSchemaSetValidErrors     (xmlSchemaValidCtxtPtr ctxt,
                                         xmlSchemaValidityErrorFunc err,
                                         xmlSchemaValidityWarningFunc warn,
                                         void *ctx);
XMLPUBFUN xmlSchemaValidCtxtPtr XMLCALL
            xmlSchemaNewValidCtxt       (xmlSchemaPtr schema);
XMLPUBFUN void XMLCALL
            xmlSchemaFreeValidCtxt      (xmlSchemaValidCtxtPtr ctxt);
XMLPUBFUN int XMLCALL
            xmlSchemaValidateDoc        (xmlSchemaValidCtxtPtr ctxt,
                                         xmlDocPtr instance);
XMLPUBFUN int XMLCALL
            xmlSchemaValidateStream     (xmlSchemaValidCtxtPtr ctxt,
                                         xmlParserInputBufferPtr input,
                                         xmlCharEncoding enc,
                                         xmlSAXHandlerPtr sax,
                                         void *user_data);
#ifdef __cplusplus
}
#endif

#endif /* LIBXML_SCHEMAS_ENABLED */
#endif /* XML_SCHEMA_H */
