#ifndef BUILDSTATUS_H
#define BUILDSTATUS_H

#include <QObject>
#include <QDateTime>

class BuildStatus : public QObject
{
public:
    BuildStatus(QObject *parent = 0);

    void setName(QString n);
    const QString *name();

    void setTime(QDateTime w);
    QString time();

    void setStatus (bool n );
    const QString *status();

private:
    // What was the name of the package?
    QString *m_packageName;
    // At this time, the symbain build log doesn't have a timestamp in it.
    // So, we will use the timestamp on the file.
    QDateTime m_when;
    // Did the build succeed?
    bool m_status;
    QString *m_PresentStatus;
};

#endif // BUILDSTATUS_H
