/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class AttributeNode
extends Node {
    private String name;
    private boolean outerJoin;
    private boolean requiresCollectionAttribute;
    private DatabaseMapping mapping;

    public AttributeNode() {
    }

    public AttributeNode(String name) {
        this.setAttributeName(name);
    }

    public Node qualifyAttributeAccess(ParseTreeContext context) {
        return (Node)context.getNodeFactory().newQualifiedAttribute(this.getLine(), this.getColumn(), context.getBaseVariable(), this.name);
    }

    public void validate(ParseTreeContext context) {
    }

    public Expression addToExpression(Expression parentExpression, GenerationContext context) {
        if (this.isCollectionAttribute()) {
            if (context.hasMemberOfNode()) {
                return parentExpression.noneOf(this.name, new ExpressionBuilder().equal(context.getMemberOfNode().getLeftExpression()));
            }
            return this.outerJoin ? parentExpression.anyOfAllowingNone(this.name) : parentExpression.anyOf(this.name);
        }
        if (this.requiresCollectionAttribute()) {
            throw JPQLException.invalidCollectionMemberDecl(context.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), this.name);
        }
        if (context.shouldUseOuterJoins() || this.isOuterJoin()) {
            return parentExpression.getAllowingNull(this.name);
        }
        return parentExpression.get(this.name);
    }

    public boolean isAttributeNode() {
        return true;
    }

    public String getAttributeName() {
        return this.name;
    }

    public void setAttributeName(String name) {
        this.name = name;
    }

    public boolean isOuterJoin() {
        return this.outerJoin;
    }

    public void setOuterJoin(boolean outerJoin) {
        this.outerJoin = outerJoin;
    }

    public boolean requiresCollectionAttribute() {
        return this.requiresCollectionAttribute;
    }

    public void setRequiresCollectionAttribute(boolean requiresCollectionAttribute) {
        this.requiresCollectionAttribute = requiresCollectionAttribute;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    public boolean isCollectionAttribute() {
        DatabaseMapping mapping = this.getMapping();
        return mapping != null && mapping.isCollectionMapping();
    }

    public DatabaseMapping resolveMapping(GenerationContext context, Class ownerClass) {
        ClassDescriptor descriptor = context.getSession().getDescriptor(ownerClass);
        return descriptor == null ? null : descriptor.getMappingForAttributeName(this.getAttributeName());
    }

    public Class resolveClass(GenerationContext context, Class ownerClass) {
        DatabaseMapping mapping = this.resolveMapping(context, ownerClass);
        if (mapping == null || mapping.isDirectToFieldMapping()) {
            return ownerClass;
        }
        ClassDescriptor descriptor = mapping.getReferenceDescriptor();
        return descriptor == null ? null : descriptor.getJavaClass();
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer();
        this.toStringIndent(indent, buffer);
        buffer.append(this.toStringDisplayName() + "[" + this.getAttributeName() + "]");
        return buffer.toString();
    }

    public String getAsString() {
        return this.getAttributeName();
    }
}

