/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.jpa.parsing.BinaryOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class PlusNode
extends BinaryOperatorNode {
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            reportQuery.addAttribute("plus", this.generateExpression(context), (Class)this.getType());
        }
    }

    public void validate(ParseTreeContext context) {
        super.validate(context);
        if (this.left != null && this.right != null) {
            TypeHelper typeHelper = context.getTypeHelper();
            this.setType(typeHelper.extendedBinaryNumericPromotion(this.left.getType(), this.right.getType()));
        }
    }

    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context);
        whereClause = ExpressionMath.add(whereClause, this.getRight().generateExpression(context));
        return whereClause;
    }

    public boolean isPlusNode() {
        return true;
    }
}

