/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementColumnPermission;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.StatementRolePermission;
import org.apache.derby.iapi.sql.dictionary.StatementRoutinePermission;
import org.apache.derby.iapi.sql.dictionary.StatementSchemaPermission;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.CreateSchemaConstantAction;

abstract class DDLConstantAction
implements ConstantAction {
    DDLConstantAction() {
    }

    static SchemaDescriptor getAndCheckSchemaDescriptor(DataDictionary dataDictionary, UUID uUID, String string) throws StandardException {
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(uUID, null);
        return schemaDescriptor;
    }

    static SchemaDescriptor getSchemaDescriptorForCreate(DataDictionary dataDictionary, Activation activation, String string) throws StandardException {
        TransactionController transactionController = activation.getLanguageConnectionContext().getTransactionExecute();
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, false);
        if (schemaDescriptor == null || schemaDescriptor.getUUID() == null) {
            block5: {
                CreateSchemaConstantAction createSchemaConstantAction = new CreateSchemaConstantAction(string, null);
                if (activation.getLanguageConnectionContext().isInitialDefaultSchema(string)) {
                    DDLConstantAction.executeCAPreferSubTrans(createSchemaConstantAction, transactionController, activation);
                } else {
                    try {
                        createSchemaConstantAction.executeConstantAction(activation);
                    }
                    catch (StandardException standardException) {
                        if (standardException.getMessageId().equals("X0Y68.S")) break block5;
                        throw standardException;
                    }
                }
            }
            schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, true);
        }
        return schemaDescriptor;
    }

    private static void executeCAPreferSubTrans(CreateSchemaConstantAction createSchemaConstantAction, TransactionController transactionController, Activation activation) throws StandardException {
        TransactionController transactionController2 = null;
        TransactionController transactionController3 = null;
        try {
            transactionController2 = transactionController3 = transactionController.startNestedUserTransaction(false);
        }
        catch (StandardException standardException) {
            transactionController2 = transactionController;
        }
        while (true) {
            try {
                createSchemaConstantAction.executeConstantAction(activation, transactionController2);
            }
            catch (StandardException standardException) {
                if (standardException.getMessageId().equals("40XL1")) {
                    if (transactionController2 == transactionController3) {
                        transactionController2 = transactionController;
                        transactionController3.destroy();
                        continue;
                    }
                } else if (standardException.getMessageId().equals("X0Y68.S")) break;
                if (transactionController2 == transactionController3) {
                    transactionController3.destroy();
                }
                throw standardException;
            }
            break;
        }
        if (transactionController2 == transactionController3) {
            transactionController3.commit();
            transactionController3.destroy();
        }
    }

    final void lockTableForDDL(TransactionController transactionController, long l, boolean bl) throws StandardException {
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, bl ? 68 : 64, 7, 5);
        conglomerateController.close();
    }

    protected String constructToString(String string, String string2) {
        return string + string2;
    }

    protected void storeConstraintDependenciesOnPrivileges(Activation activation, Dependent dependent, UUID uUID, ProviderInfo[] providerInfoArray) throws StandardException {
        List list;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        String string = dataDictionary.getAuthorizationDatabaseOwner();
        String string2 = languageConnectionContext.getAuthorizationId();
        SettableBoolean settableBoolean = new SettableBoolean();
        if (!languageConnectionContext.getAuthorizationId().equals(dataDictionary.getAuthorizationDatabaseOwner()) && (list = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                StatementPermission statementPermission;
                StatementPermission statementPermission2 = (StatementPermission)iterator.next();
                if (!(statementPermission2 instanceof StatementTablePermission) ? statementPermission2 instanceof StatementSchemaPermission || statementPermission2 instanceof StatementRolePermission || !this.inProviderSet(providerInfoArray, ((StatementRoutinePermission)(statementPermission = (StatementRoutinePermission)statementPermission2)).getRoutineUUID()) : ((StatementTablePermission)(statementPermission = (StatementTablePermission)statementPermission2)).getPrivType() != 2 || !((StatementTablePermission)statementPermission).getTableUUID().equals(uUID)) continue;
                PermissionsDescriptor permissionsDescriptor = statementPermission2.getPermissionDescriptor(languageConnectionContext.getAuthorizationId(), dataDictionary);
                if (permissionsDescriptor == null) {
                    permissionsDescriptor = statementPermission2.getPermissionDescriptor("PUBLIC", dataDictionary);
                    boolean bl = false;
                    if (permissionsDescriptor == null || permissionsDescriptor instanceof ColPermsDescriptor && !((StatementColumnPermission)statementPermission2).allColumnsCoveredByUserOrPUBLIC(languageConnectionContext.getAuthorizationId(), dataDictionary)) {
                        bl = true;
                        permissionsDescriptor = DDLConstantAction.findRoleUsage(activation, statementPermission2);
                    }
                    if (!permissionsDescriptor.checkOwner(languageConnectionContext.getAuthorizationId())) {
                        dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                        if (bl) {
                            DDLConstantAction.trackRoleDependency(activation, dependent, settableBoolean);
                        }
                    }
                } else if (!permissionsDescriptor.checkOwner(languageConnectionContext.getAuthorizationId())) {
                    dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                    if (permissionsDescriptor instanceof ColPermsDescriptor) {
                        statementPermission = (StatementColumnPermission)statementPermission2;
                        permissionsDescriptor = ((StatementColumnPermission)statementPermission).getPUBLIClevelColPermsDescriptor(languageConnectionContext.getAuthorizationId(), dataDictionary);
                        if (permissionsDescriptor != null && permissionsDescriptor.getObjectID() != null) {
                            dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                        }
                        if (!((StatementColumnPermission)statementPermission).allColumnsCoveredByUserOrPUBLIC(languageConnectionContext.getAuthorizationId(), dataDictionary)) {
                            DDLConstantAction.trackRoleDependency(activation, dependent, settableBoolean);
                        }
                    }
                }
                if (statementPermission2 instanceof StatementRoutinePermission) continue;
                break;
            }
        }
    }

    private static PermissionsDescriptor findRoleUsage(Activation activation, StatementPermission statementPermission) throws StandardException {
        String string;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        RoleGrantDescriptor roleGrantDescriptor = null;
        String string2 = languageConnectionContext.getCurrentRoleId(activation);
        String string3 = dataDictionary.getAuthorizationDatabaseOwner();
        String string4 = languageConnectionContext.getAuthorizationId();
        PermissionsDescriptor permissionsDescriptor = null;
        roleGrantDescriptor = dataDictionary.getRoleGrantDescriptor(string2, string4, string3);
        if (roleGrantDescriptor == null) {
            roleGrantDescriptor = dataDictionary.getRoleGrantDescriptor(string2, "PUBLIC", string3);
        }
        RoleClosureIterator roleClosureIterator = dataDictionary.createRoleClosureIterator(activation.getTransactionController(), string2, true);
        while (permissionsDescriptor == null && (string = roleClosureIterator.next()) != null) {
            permissionsDescriptor = statementPermission.getPermissionDescriptor(string, dataDictionary);
        }
        return permissionsDescriptor;
    }

    private static void trackRoleDependency(Activation activation, Dependent dependent, SettableBoolean settableBoolean) throws StandardException {
        if (!settableBoolean.get()) {
            LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            DependencyManager dependencyManager = dataDictionary.getDependencyManager();
            String string = languageConnectionContext.getCurrentRoleId(activation);
            RoleGrantDescriptor roleGrantDescriptor = dataDictionary.getRoleDefinitionDescriptor(string);
            dependencyManager.addDependency(dependent, roleGrantDescriptor, languageConnectionContext.getContextManager());
            settableBoolean.set(true);
        }
    }

    protected void storeViewTriggerDependenciesOnPrivileges(Activation activation, Dependent dependent) throws StandardException {
        List list;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        String string = dataDictionary.getAuthorizationDatabaseOwner();
        String string2 = languageConnectionContext.getAuthorizationId();
        SettableBoolean settableBoolean = new SettableBoolean();
        if (!string2.equals(string) && (list = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                StatementPermission statementPermission = (StatementPermission)iterator.next();
                if (statementPermission instanceof StatementSchemaPermission || statementPermission instanceof StatementRolePermission) continue;
                PermissionsDescriptor permissionsDescriptor = statementPermission.getPermissionDescriptor(languageConnectionContext.getAuthorizationId(), dataDictionary);
                if (permissionsDescriptor == null) {
                    permissionsDescriptor = statementPermission.getPermissionDescriptor("PUBLIC", dataDictionary);
                    boolean bl = false;
                    if (permissionsDescriptor == null || permissionsDescriptor instanceof ColPermsDescriptor && !((StatementColumnPermission)statementPermission).allColumnsCoveredByUserOrPUBLIC(languageConnectionContext.getAuthorizationId(), dataDictionary)) {
                        bl = true;
                        permissionsDescriptor = DDLConstantAction.findRoleUsage(activation, statementPermission);
                    }
                    if (permissionsDescriptor.checkOwner(languageConnectionContext.getAuthorizationId())) continue;
                    dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                    if (!bl) continue;
                    DDLConstantAction.trackRoleDependency(activation, dependent, settableBoolean);
                    continue;
                }
                if (permissionsDescriptor.checkOwner(languageConnectionContext.getAuthorizationId())) continue;
                dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                if (!(permissionsDescriptor instanceof ColPermsDescriptor)) continue;
                StatementColumnPermission statementColumnPermission = (StatementColumnPermission)statementPermission;
                permissionsDescriptor = statementColumnPermission.getPUBLIClevelColPermsDescriptor(languageConnectionContext.getAuthorizationId(), dataDictionary);
                if (permissionsDescriptor != null && permissionsDescriptor.getObjectID() != null) {
                    dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                }
                if (statementColumnPermission.allColumnsCoveredByUserOrPUBLIC(languageConnectionContext.getAuthorizationId(), dataDictionary)) continue;
                DDLConstantAction.trackRoleDependency(activation, dependent, settableBoolean);
            }
        }
    }

    private boolean inProviderSet(ProviderInfo[] providerInfoArray, UUID uUID) {
        if (providerInfoArray == null) {
            return false;
        }
        for (int i = 0; i < providerInfoArray.length; ++i) {
            if (!providerInfoArray[i].getObjectId().equals(uUID)) continue;
            return true;
        }
        return false;
    }

    protected void addColumnDependencies(LanguageConnectionContext languageConnectionContext, DataDictionary dataDictionary, TableDescriptor tableDescriptor, ColumnInfo columnInfo) throws StandardException {
        ProviderInfo[] providerInfoArray = columnInfo.providers;
        if (providerInfoArray != null) {
            DependencyManager dependencyManager = dataDictionary.getDependencyManager();
            ContextManager contextManager = languageConnectionContext.getContextManager();
            int n = providerInfoArray.length;
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(columnInfo.name);
            DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(dataDictionary);
            for (int i = 0; i < n; ++i) {
                ProviderInfo providerInfo = providerInfoArray[i];
                DependableFinder dependableFinder = providerInfo.getDependableFinder();
                UUID uUID = providerInfo.getObjectId();
                Provider provider = (Provider)dependableFinder.getDependable(dataDictionary, uUID);
                dependencyManager.addDependency(defaultDescriptor, provider, contextManager);
            }
        }
    }

    private class SettableBoolean {
        boolean value = false;

        SettableBoolean() {
        }

        void set(boolean bl) {
            this.value = bl;
        }

        boolean get() {
            return this.value;
        }
    }
}

