/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant;

import com.nokia.helium.core.ant.types.ConditionType;
import java.net.URL;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class AtsCondition
extends ConditionType {
    private Logger log = Logger.getLogger(AtsCondition.class);
    private int sleeptimesecs = 60;

    public void setSleeptime(int seconds) {
        this.sleeptimesecs = seconds;
    }

    public boolean eval() {
        String bid = this.project.getProperty("diamonds.build.id");
        if (bid == null) {
            this.log.info((Object)"Diamonds not enabled");
        } else {
            boolean testsfound = false;
            this.log.info((Object)"Looking for tests in diamonds");
            SAXReader xmlReader = new SAXReader();
            while (!testsfound) {
                int testsrun;
                Document antDoc = null;
                try {
                    URL url = new URL("http://" + this.project.getProperty("diamonds.host") + bid + "?fmt=xml");
                    antDoc = xmlReader.read(url);
                }
                catch (Exception e) {
                    this.log.error((Object)("Not able to read the Diamonds URL http://" + this.project.getProperty("diamonds.host") + bid + "?fmt=xml" + e.getMessage()));
                }
                Iterator iterator = antDoc.selectNodes("//test/failed").iterator();
                while (iterator.hasNext()) {
                    testsfound = true;
                    Element e = (Element)iterator.next();
                    String failed = e.getText();
                    if (failed.equals("0")) continue;
                    this.log.error((Object)"ATS tests failed");
                    for (Element e2 : antDoc.selectNodes("//actual_result")) {
                        this.log.error((Object)e2.getText());
                    }
                    return false;
                }
                int noofdrops = Integer.parseInt(this.project.getProperty("drop.file.counter"));
                if (noofdrops > 0 && (testsrun = antDoc.selectNodes("//test").size()) < noofdrops) {
                    this.log.info((Object)(testsrun + " test completed, " + noofdrops + " total"));
                    testsfound = false;
                }
                if (testsfound) continue;
                this.log.info((Object)("Tests not found sleeping for " + this.sleeptimesecs + " seconds"));
                try {
                    Thread.sleep(this.sleeptimesecs * 1000);
                }
                catch (InterruptedException e) {
                    this.log.debug((Object)("Interrupted while reading ATS build status " + e.getMessage()));
                }
            }
        }
        return true;
    }
}

