/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.taskdefs;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;

public abstract class AbstractScmBaseTask
extends Task {
    private String database;
    private String password;
    private String ccmProject;
    private Integer verbosity;
    private StringBuffer commandString = new StringBuffer();
    private List<SCMCommandArgument> commands = new ArrayList<SCMCommandArgument>();

    public String getCcmProject() {
        return this.ccmProject;
    }

    public void setCcmProject(String ccmProject) {
        this.ccmProject = ccmProject;
        this.log("Set ccmProject to " + ccmProject);
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
        this.log("Set database to " + database);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.log("Set password to ****** ");
    }

    public Integer getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(Integer verbosity) {
        this.verbosity = verbosity;
        this.log("Set verbosity to " + verbosity);
    }

    public void execute() {
        try {
            this.setExecutionScript();
            this.buildCommandList();
            this.handleCommandArguments();
            this.configureVerbosity();
            this.runCommand();
            this.log("Completed successfully.");
        }
        catch (Throwable th) {
            th.printStackTrace();
            if (th instanceof BuildException) {
                throw (RuntimeException)th;
            }
            this.raiseError("Script execution failure.");
        }
    }

    protected void append2CommandString(String prefix, Object cmd) {
        if (cmd != null) {
            this.commandString.append(prefix);
            this.commandString.append(" ");
            this.commandString.append(cmd);
            this.commandString.append(" ");
        }
    }

    protected void append2CommandString(String prefix, Boolean bool) {
        if (bool != null && bool.booleanValue()) {
            this.append2CommandString(prefix);
        }
    }

    protected void append2CommandString(String cmd) {
        this.commandString.append(cmd);
        this.commandString.append(" ");
    }

    protected void raiseError(String errorMessage) {
        StringBuffer buffer = new StringBuffer("[").append(this.getTaskName()).append("] Error: ").append(errorMessage);
        throw new BuildException(buffer.toString());
    }

    protected void addCommandArg(String fieldName, String cmdArg, Boolean required, Object fieldValue) {
        SCMCommandArgument cmdObj = new SCMCommandArgument(fieldName, cmdArg, required, fieldValue);
        this.commands.add(cmdObj);
    }

    protected void addCommandArg(String fieldName, String cmdArg, Object fieldValue) {
        this.addCommandArg(fieldName, cmdArg, false, fieldValue);
    }

    protected abstract void validateArguments();

    protected abstract void setExecutionScript();

    protected abstract void buildCommandList();

    protected abstract String getVerbosity(int var1);

    private Field getField(Class<?> clazz, String fieldName) {
        Field field = null;
        if (clazz != null) {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException nsfe) {
                field = this.getField(clazz.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    private void handleCommandArguments() throws Exception {
        StringBuffer missingArgs = new StringBuffer();
        Field field = null;
        for (SCMCommandArgument cmdObj : this.commands) {
            field = this.getField(((Object)((Object)this)).getClass(), cmdObj.fieldName);
            if (field == null) continue;
            Object fieldValue = field.getType().cast(cmdObj.fieldValue);
            this.check4MandatoryCmdArguments(cmdObj, fieldValue, missingArgs);
            this.buildCommand(cmdObj, fieldValue);
        }
        this.handleMissingArguments(missingArgs);
        this.validateArguments();
    }

    private void check4MandatoryCmdArguments(SCMCommandArgument cmdObj, Object fieldValue, StringBuffer missingArgs) {
        if (cmdObj.required.booleanValue() && fieldValue == null) {
            missingArgs.append(cmdObj.fieldName);
            missingArgs.append(" ");
        }
    }

    private void buildCommand(SCMCommandArgument cmdObj, Object fieldValue) {
        if (fieldValue instanceof Boolean) {
            this.append2CommandString(cmdObj.commandArgument, (Boolean)fieldValue);
        } else {
            this.append2CommandString(cmdObj.commandArgument, fieldValue);
        }
    }

    private void handleMissingArguments(StringBuffer missingArgs) {
        if (missingArgs.length() > 0) {
            this.raiseError("mandatory attributes are not defined - " + missingArgs.toString());
        }
    }

    private void configureVerbosity() {
        if (this.verbosity != null) {
            this.append2CommandString(this.getVerbosity(this.verbosity));
        }
    }

    private void runCommand() throws Exception {
        String[] cmdline = this.commandString.toString().split(" ");
        Execute exe = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 0));
        exe.setAntRun(this.getProject());
        exe.setCommandline(cmdline);
        exe.setVMLauncher(false);
        int retval = exe.execute();
        if (Execute.isFailure((int)retval)) {
            throw new RuntimeException(cmdline[0] + " failed with return code " + retval);
        }
    }

    private class SCMCommandArgument {
        private String fieldName;
        private Object fieldValue;
        private String commandArgument;
        private Boolean required;

        protected SCMCommandArgument(String fieldName, String commandArg, Boolean reqd, Object fieldValue) {
            this.fieldName = fieldName;
            this.commandArgument = commandArg;
            this.required = reqd;
            this.fieldValue = fieldValue;
        }
    }
}

