/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.Action;
import com.oopsconsultancy.xmltask.BufferStore;
import org.apache.tools.ant.Task;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CopyAction
extends Action {
    protected final String propertyBufferName;
    protected final boolean append;
    protected final boolean attrValue;
    protected final Task task;
    protected final boolean isProperty;
    protected final boolean trim;
    private String propertyToWrite = null;
    private final String propertySeparator;

    public CopyAction(String propertyBufferName, boolean append, boolean attrValue, Task task, boolean isProperty, boolean trim, String propertySeparator) {
        this.propertyBufferName = propertyBufferName;
        this.trim = trim;
        this.append = append;
        this.attrValue = attrValue;
        this.task = task;
        this.isProperty = isProperty;
        String string = this.propertySeparator = propertySeparator == null ? " " : propertySeparator;
        if (attrValue && isProperty) {
            task.log("Specifying 'attr' for properties is now deprecated", 3);
        }
    }

    protected void record(Node node) throws Exception {
        if (node instanceof Attr && this.attrValue) {
            Document doc = node.getOwnerDocument();
            String value = ((Attr)node).getValue();
            node = doc.createTextNode(value);
        }
        if (!this.isProperty) {
            if (this.trim) {
                this.task.log("Trimming not available when copying/cutting to buffers", 1);
            }
            BufferStore.set(this.propertyBufferName, node, this.append, this.task);
        } else {
            if (node instanceof Text || node instanceof Comment || node instanceof Attr) {
                String value = node.getNodeValue();
                if (value != null && this.trim) {
                    value = value.trim();
                }
                this.task.log("Copying '" + value + "' to property " + this.propertyBufferName, 3);
                if (this.propertyToWrite == null) {
                    this.propertyToWrite = value;
                } else if (this.append) {
                    this.propertyToWrite = this.propertyToWrite + this.propertySeparator + value;
                }
            } else if (node == null) {
                this.task.log("Can only copy/cut text() nodes and attribute values to properties (found no node)", 1);
            } else {
                this.task.log("Can only copy/cut text() nodes and attribute values to properties (found " + node.getClass().getName() + ")", 1);
            }
            if (this.append) {
                this.task.log("Cannot append values to properties", 1);
            }
        }
    }

    @Override
    protected void completeAction() {
        if (this.propertyToWrite != null) {
            this.task.getProject().setNewProperty(this.propertyBufferName, this.propertyToWrite);
        }
        this.propertyToWrite = null;
    }

    @Override
    public boolean apply(Node node) throws Exception {
        this.record(node);
        return true;
    }

    public String toString() {
        return "CopyAction(" + this.propertyBufferName + ")";
    }
}

