/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.Action;
import com.oopsconsultancy.xmltask.BufferStore;
import com.oopsconsultancy.xmltask.TextAction;
import com.oopsconsultancy.xmltask.ant.XmlTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class RegexpAction
extends Action {
    private final String ptrn;
    private final String replace;
    private final String property;
    private final String buffer;
    private XmlTask task;
    private boolean caseInsensitive;
    private boolean unicodeCase;

    private RegexpAction(XmlTask task, String pattern, String replace, String property, String buffer) {
        this.task = task;
        if (pattern == null) {
            throw new IllegalArgumentException("Must specify a pattern");
        }
        this.ptrn = pattern;
        this.replace = replace;
        this.property = property;
        this.buffer = buffer;
    }

    @Override
    public boolean apply(Node node) throws Exception {
        String str;
        if (node instanceof Element) {
            Element e = (Element)node;
            NodeList nl = e.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                this.apply(nl.item(i));
            }
        } else if (TextAction.isTextNode(node)) {
            String str2 = this.performRegexp(node);
            if (str2 != null) {
                node.setNodeValue(str2);
            }
        } else if (node instanceof Attr && (str = this.performRegexp(node)) != null) {
            ((Attr)node).setValue(str);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String performRegexp(Node node) {
        int flags = 0;
        if (this.caseInsensitive) {
            flags |= 2;
        }
        if (this.unicodeCase) {
            flags |= 0x40;
        }
        Pattern pattern = Pattern.compile(this.ptrn, flags);
        String str = node.getNodeValue();
        if (str == null) {
            return null;
        }
        if (this.replace != null) {
            Matcher m = pattern.matcher(str);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, this.replace);
            }
            m.appendTail(sb);
            return sb.toString();
        }
        if (this.property != null) {
            Matcher m = pattern.matcher(str);
            if (!m.matches()) throw new IllegalStateException("Failed to match property value in '" + str + "' using '" + pattern.pattern() + "'");
            String value = this.getGroupedOrMatched(m);
            this.task.log("Setting property " + this.property + "=" + value + " using '" + pattern.pattern() + "'", 3);
            this.task.getProject().setNewProperty(this.property, value);
            return null;
        } else {
            if (this.buffer == null) return null;
            Matcher m = pattern.matcher(str);
            if (!m.matches()) throw new IllegalStateException("Failed to match buffer value in '" + str + "' using '" + pattern.pattern() + "'");
            String value = this.getGroupedOrMatched(m);
            this.task.log("Setting buffer " + this.buffer + "=" + value + " using '" + pattern.pattern() + "'", 3);
            Text newnode = node.getOwnerDocument().createTextNode(value);
            BufferStore.set(this.buffer, newnode, false, this.task);
        }
        return null;
    }

    private String getGroupedOrMatched(Matcher m) {
        if (m.groupCount() > 0) {
            return m.group(1);
        }
        return m.group();
    }

    public String toString() {
        return "RegexpAction()";
    }

    public static RegexpAction createCopyToProperty(XmlTask task, String pattern, String property) {
        return new RegexpAction(task, pattern, null, property, null);
    }

    public static RegexpAction createReplacement(XmlTask task, String pattern, String replace) {
        return new RegexpAction(task, pattern, replace, null, null);
    }

    public static RegexpAction createCopyToBuffer(XmlTask task, String pattern, String buffer) {
        return new RegexpAction(task, pattern, null, null, buffer);
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public void setUnicodeCase(boolean unicodeCase) {
        this.unicodeCase = unicodeCase;
    }
}

