/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.checks.AbstractCheck;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;

public abstract class AbstractScriptCheck
extends AbstractCheck {
    protected void writeJepFile(String name, String text) {
        if (text.contains("${")) {
            this.log("${ found in " + name);
        }
        try {
            String heliumpath = new File(this.getProject().getProperty("helium.build.dir")).getCanonicalPath();
            new File(heliumpath + File.separator + "jep").mkdirs();
            File file = new File(heliumpath + File.separator + "jep" + File.separator + name + "_jep.py");
            PrintWriter output = new PrintWriter(new FileOutputStream(file));
            output.write("def abc():\n");
            output.write("    attributes = {} # pylint: disable-msg=C0103\n");
            output.write("    elements = {} # pylint: disable-msg=C0103\n");
            output.write("    project = None # pylint: disable-msg=C0103\n");
            output.write("    self = None # pylint: disable-msg=C0103\n");
            text = text.replace(" File(", " self.File(");
            for (String t : text.split("\n")) {
                output.write("    " + t + "\n");
            }
            output.close();
            if (text.contains("import ")) {
                File file2 = new File(heliumpath + File.separator + "test_jython.xml");
                PrintWriter output2 = new PrintWriter(new FileOutputStream(file2, true));
                output2.write("try:\n");
                for (String line : text.split("\n")) {
                    if (!line.trim().startsWith("import ") && !line.trim().startsWith("from ")) continue;
                    output2.write("    " + line + "\n");
                }
                output2.write("except ImportError, e:\n");
                output2.write("    print '" + name + " failed: ' + str(e)\n");
                output2.close();
            }
        }
        catch (Exception e) {
            throw new BuildException("Not able to write JEP File " + name + "_jep.py");
        }
    }

    protected void checkJepPropertiesInText(String text) {
        Pattern p1 = Pattern.compile("getProperty\\([\"']([a-zA-Z0-9\\.]*)[\"']\\)");
        Matcher m1 = p1.matcher(text);
        ArrayList<String> props = new ArrayList<String>();
        while (m1.find()) {
            props.add(m1.group(1));
        }
        for (String group : props) {
            this.checkPropertyInModel(group);
        }
    }
}

