/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template;

import info.bliki.wiki.filter.TemplateParser;
import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import info.bliki.wiki.template.expr.eval.DoubleEvaluator;
import java.io.IOException;
import java.util.ArrayList;

public class Expr
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Expr();

    public String parseFunction(char[] src, int beginIndex, int endIndex, IWikiModel model) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        WikipediaScanner.splitByPipe(src, beginIndex, endIndex, list);
        if (list.size() > 0) {
            String expression = (String)list.get(0);
            if (expression.length() == 0) {
                return null;
            }
            StringBuilder conditionBuffer = new StringBuilder(expression.length());
            TemplateParser.parse(expression, model, conditionBuffer, false);
            if (conditionBuffer.length() > 0) {
                try {
                    DoubleEvaluator engine = new DoubleEvaluator();
                    double d = engine.evaluate(conditionBuffer.toString());
                    double dInt = Math.rint(d);
                    if (Math.abs(dInt - d) < DoubleEvaluator.EPSILON) {
                        return Long.toString(Math.round(d));
                    }
                    return Double.toString(d);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

