/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform;

import com.sardak.antform.AbstractTaskWindow;
import com.sardak.antform.gui.CallBack;
import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.interfaces.PropertyComponent;
import com.sardak.antform.types.BaseType;
import com.sardak.antform.types.BooleanProperty;
import com.sardak.antform.types.Button;
import com.sardak.antform.types.ButtonBar;
import com.sardak.antform.types.Cancel;
import com.sardak.antform.types.CheckSelectionProperty;
import com.sardak.antform.types.DateProperty;
import com.sardak.antform.types.DummyListProperty;
import com.sardak.antform.types.DummyNumberProperty;
import com.sardak.antform.types.FileSelectionProperty;
import com.sardak.antform.types.MultilineTextProperty;
import com.sardak.antform.types.RadioSelectionProperty;
import com.sardak.antform.types.SelectionProperty;
import com.sardak.antform.types.Separator;
import com.sardak.antform.types.Tab;
import com.sardak.antform.types.Table;
import com.sardak.antform.types.TextProperty;
import com.sardak.antform.util.ActionType;
import com.sardak.antform.util.FileProperties;
import com.sardak.antform.util.TargetInvoker;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class AntForm
extends AbstractTaskWindow
implements CallBack {
    private String okMessage = "OK";
    private boolean okMessageChanged = false;
    private String resetMessage = "Reset";
    private boolean resetMessageChanged = false;
    private String cancelMessage = null;
    private String save = null;
    private String nextTarget;
    private String previousTarget = null;
    private boolean built = false;
    private ButtonBar controlBar = null;
    private boolean controlBarIncompatibilityDetected = false;

    public void setFocus(String focus) {
        this.log("Attribute 'focus' of antform is not supported anymore. Use the widget 'focus' attribute instead.", 1);
    }

    public String getNextTarget() {
        return this.nextTarget;
    }

    public void setNextTarget(String nextTarget) {
        this.log("nexttarget attribute is deprecated. Use <controlbar> instead.", 1);
        if (this.controlBar != null) {
            this.controlBarIncompatibilityDetected();
        }
        this.nextTarget = nextTarget;
    }

    public String getPreviousTarget() {
        return this.previousTarget;
    }

    public void setPreviousTarget(String previousTarget) {
        this.log("previoustarget attribute is deprecated. Use <controlbar> instead.", 1);
        if (this.controlBar != null) {
            this.controlBarIncompatibilityDetected();
        }
        this.previousTarget = previousTarget;
    }

    public String getOkMessage() {
        return this.okMessage;
    }

    public void setOkMessage(String okMessage) {
        this.log("okmessage attribute is deprecated. Use <controlbar> instead.", 1);
        if (this.controlBar != null) {
            this.controlBarIncompatibilityDetected();
        }
        this.okMessage = okMessage;
        this.okMessageChanged = true;
    }

    public String getResetMessage() {
        return this.resetMessage;
    }

    public void setResetMessage(String resetMessage) {
        this.log("resetmessage attribute is deprecated. Use <controlbar> instead.", 1);
        if (this.controlBar != null) {
            this.controlBarIncompatibilityDetected();
        }
        this.resetMessage = resetMessage;
        this.resetMessageChanged = true;
    }

    public String getCancelMessage() {
        return this.cancelMessage;
    }

    public void setCancelMessage(String cancelMessage) {
        this.log("cancelmessage attribute is deprecated. Use <controlbar> instead.", 1);
        if (this.controlBar != null) {
            this.controlBarIncompatibilityDetected();
        }
        this.cancelMessage = cancelMessage;
    }

    public String getSave() {
        return this.save;
    }

    public void setSave(String save) {
        this.save = save;
    }

    public void addConfiguredTextProperty(TextProperty textProperty) {
        this.widgets.add(textProperty);
    }

    public void addConfiguredCancel(Cancel cancel) {
        this.log("<cancel> element is deprecated. Use <controlbar> instead.", 1);
        if (this.controlBar != null) {
            this.controlBarIncompatibilityDetected();
        }
        this.cancelMessage = cancel.getLabel();
    }

    public void addConfiguredSeparator(Separator separator) {
        this.widgets.add(separator);
    }

    public void addConfiguredDateProperty(DateProperty dateProperty) {
        this.widgets.add(dateProperty);
    }

    public void addConfiguredNumberProperty(DummyNumberProperty numberProperty) {
        this.widgets.add(numberProperty);
    }

    public void addConfiguredListProperty(DummyListProperty listProperty) {
        this.widgets.add(listProperty);
    }

    public void addConfiguredMultilineTextProperty(MultilineTextProperty multilineTextProperty) {
        this.widgets.add(multilineTextProperty);
    }

    public void addConfiguredSelectionProperty(SelectionProperty selectionProperty) {
        this.widgets.add(selectionProperty);
    }

    public void addConfiguredTab(Tab tab) {
        this.widgets.add(tab);
        this.tabbed = true;
    }

    public void addConfiguredRadioSelectionProperty(RadioSelectionProperty radioSelectionProperty) {
        this.widgets.add(radioSelectionProperty);
    }

    public void addConfiguredCheckSelectionProperty(CheckSelectionProperty checkSelectionProperty) {
        this.widgets.add(checkSelectionProperty);
    }

    public void addConfiguredBooleanProperty(BooleanProperty booleanProperty) {
        this.widgets.add(booleanProperty);
    }

    public void addConfigured(BaseType widget) {
        this.widgets.add(widget);
    }

    public void addConfiguredLinkBar(ButtonBar buttonBar) {
        this.log("<linkbar> nested elements are deprecated. Use <buttonbar> instead.");
        this.addConfiguredButtonBar(buttonBar);
    }

    public void addConfiguredTable(Table table) {
        this.widgets.add(table);
    }

    public void addConfiguredFileSelectionProperty(FileSelectionProperty fileSelectionProperty) {
        this.widgets.add(fileSelectionProperty);
    }

    public void addConfiguredControlBar(ButtonBar buttonBar) {
        if (this.okMessageChanged || this.resetMessageChanged || this.nextTarget != null || this.previousTarget != null || this.cancelMessage != null) {
            this.controlBarIncompatibilityDetected();
        }
        this.controlBar = buttonBar;
        buttonBar.register(this.getActionRegistry());
    }

    public void addPrintAvailableFontFamilies(Object o) {
        String[] f = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < f.length; ++i) {
            this.log(f[i]);
        }
    }

    public void init() throws BuildException {
        this.widgets = new ArrayList();
    }

    public void build() {
        if (this.controlBar == null) {
            this.createControlButton(1, this.cancelMessage, null);
            if (this.previousTarget == null) {
                this.createControlButton(2, this.resetMessage, null);
            } else {
                this.createControlButton(0, this.resetMessage, this.previousTarget);
            }
            this.createControlButton(0, this.okMessage, this.nextTarget);
        }
        if (this.controlBar != null && !this.controlBar.isEmpty()) {
            this.controlBar.setAlign("East");
            this.controlBar.setMargins(3, 3, 3, 3);
            ControlPanel controlPanel = this.control.getPanel();
            this.controlBar.applyStylesheet(controlPanel);
            controlPanel.addButtonPanel(this.controlBar.getPanel());
            this.controlBar.register(this.getActionRegistry());
        }
        super.build();
        this.built = true;
    }

    public void execute() throws BuildException {
        do {
            this.preliminaries();
            if (!this.built) {
                this.build();
            }
            if (!this.shouldShow()) continue;
            super.execute();
            this.reset();
            this.control.show();
            if (this.getActionSource() != null && this.getActionSource().getActionType() == 0 && this.save != null) {
                this.save();
            }
            if (this.dynamic) {
                this.built = false;
                this.control = null;
            }
            if (this.getActionSource() == null || this.getActionSource().getTarget() == null || this.findTargetByName(this.getActionSource().getTarget()) == null) continue;
            TargetInvoker invoker = new TargetInvoker(this, this.getActionSource());
            invoker.perform();
        } while (this.isLoop() && this.getActionSource() != null && !this.getActionSource().isLoopExit() && this.shouldShow());
    }

    private void controlBarIncompatibilityDetected() {
        if (!this.controlBarIncompatibilityDetected) {
            this.log("<controlbar> is incompatible with attributes okmessage, resetmessage, nexttarget, previoustarget and with <cancel> element. Use <controlbar> only.", 0);
            this.needFail = true;
            this.controlBarIncompatibilityDetected = true;
        }
    }

    private void createControlButton(int type, String label, String target) {
        if (label != null && !label.equals("")) {
            Button button = new Button();
            ActionType actionType = new ActionType();
            actionType.setValue(ActionType.getType(type));
            button.setType(actionType);
            button.setLabel(label);
            button.setTarget(target);
            if (this.controlBar == null) {
                this.controlBar = new ButtonBar();
            }
            this.controlBar.addConfiguredButton(button);
        }
    }

    private void save() {
        try {
            File file = new File(this.save);
            FileProperties props = new FileProperties(file);
            props.store(this.getFormProperties());
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private Properties getFormProperties() {
        Properties formProperties = null;
        Iterator iter = this.displayedWidgets.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof PropertyComponent)) continue;
            if (formProperties == null) {
                formProperties = new Properties();
            }
            String property = ((PropertyComponent)o).getProperty();
            formProperties.setProperty(property, this.getProject().getProperty(property));
        }
        return formProperties;
    }
}

