/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.ant.types.LogMetaDataInput;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

abstract class XMLLogMetaDataInput
extends LogMetaDataInput {
    private Logger log = Logger.getLogger(XMLLogMetaDataInput.class);
    private XMLInputFactory xmlInputFactory;
    private XMLStreamReader xmlStreamReader;
    private boolean inParsing;

    public XMLLogMetaDataInput() {
        try {
            this.inParsing = true;
            this.xmlInputFactory = XMLInputFactory.newInstance();
            this.xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            this.xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        }
        catch (Exception ex) {
            this.log.debug((Object)"Exception while initializing stax processing", (Throwable)ex);
        }
    }

    private void close() {
        try {
            if (this.xmlStreamReader != null) {
                this.xmlStreamReader.close();
                this.xmlStreamReader = null;
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"Exception while closing xml stream", (Throwable)ex);
        }
    }

    @Override
    boolean isEntryCreated(File currentFile) throws Exception {
        boolean entryCreated = false;
        if (this.inParsing) {
            if (this.xmlStreamReader == null) {
                this.log.debug((Object)("Processing file: " + currentFile));
                this.xmlStreamReader = this.xmlInputFactory.createXMLStreamReader(currentFile.toString(), new BufferedInputStream(new FileInputStream(currentFile)));
            }
            int eventType = this.xmlStreamReader.getEventType();
            while (this.xmlStreamReader.hasNext()) {
                eventType = this.xmlStreamReader.next();
                switch (eventType) {
                    case 1: {
                        entryCreated = this.startElement(this.xmlStreamReader);
                        break;
                    }
                    case 2: {
                        entryCreated = this.endElement(this.xmlStreamReader);
                        break;
                    }
                    case 4: {
                        entryCreated = this.characters(this.xmlStreamReader);
                        break;
                    }
                }
                if (!entryCreated) continue;
                return true;
            }
            if (this.xmlStreamReader != null) {
                this.close();
            }
            this.inParsing = false;
        }
        return false;
    }

    abstract boolean startElement(XMLStreamReader var1) throws Exception;

    abstract boolean endElement(XMLStreamReader var1) throws Exception;

    abstract boolean characters(XMLStreamReader var1) throws Exception;
}

