/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.aq;

import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import oracle.AQ.AQDequeueOption;
import oracle.AQ.AQEnqueueOption;
import oracle.AQ.AQMessage;
import oracle.AQ.AQQueue;
import oracle.AQ.AQRawPayload;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.internal.eis.adapters.aq.AQConnection;
import org.eclipse.persistence.internal.eis.adapters.aq.AQDequeueInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.aq.AQEnqueueInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.aq.AQInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.aq.AQRecord;

public class AQInteraction
implements Interaction {
    protected AQConnection connection;

    public AQInteraction(AQConnection connection) {
        this.connection = connection;
    }

    public void clearWarnings() {
    }

    public void close() {
    }

    public Record execute(InteractionSpec spec, Record input) throws ResourceException {
        AQRecord record = new AQRecord();
        this.execute(spec, input, (Record)record);
        return record;
    }

    public boolean execute(InteractionSpec spec, Record input, Record output) throws ResourceException {
        if (!(spec instanceof AQInteractionSpec)) {
            throw EISException.invalidAQInteractionSpecType();
        }
        if (!(input instanceof AQRecord) || !(output instanceof AQRecord)) {
            throw EISException.invalidAQRecordType();
        }
        boolean autocommit = false;
        if (!this.connection.getAQTransaction().isInTransaction()) {
            autocommit = true;
            this.connection.getAQTransaction().begin();
        }
        try {
            if (spec instanceof AQEnqueueInteractionSpec) {
                this.executeEnqueueInteraction((AQEnqueueInteractionSpec)spec, (AQRecord)input, (AQRecord)output);
            } else if (spec instanceof AQDequeueInteractionSpec) {
                this.executeDequeueInteraction((AQDequeueInteractionSpec)spec, (AQRecord)input, (AQRecord)output);
            }
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString());
        }
        finally {
            if (autocommit) {
                this.connection.getAQTransaction().commit();
            }
        }
        return true;
    }

    protected void executeEnqueueInteraction(AQEnqueueInteractionSpec spec, AQRecord input, AQRecord output) throws ResourceException {
        try {
            AQQueue queue = this.connection.getSession().getQueue(spec.getSchema(), spec.getQueue());
            AQMessage message = queue.createMessage();
            AQRawPayload payload = message.getRawPayload();
            if (input.size() != 1) {
                throw EISException.invalidAQInput();
            }
            byte[] bytes = null;
            if (input.get(0) instanceof String) {
                bytes = ((String)input.get(0)).getBytes();
            } else if (input.get(0) instanceof byte[]) {
                bytes = (byte[])input.get(0);
            } else {
                throw EISException.invalidAQInput();
            }
            payload.setStream(bytes, bytes.length);
            AQEnqueueOption enqueueOption = spec.getOptions();
            if (enqueueOption == null) {
                enqueueOption = new AQEnqueueOption();
            }
            queue.enqueue(enqueueOption, message);
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString());
        }
    }

    protected void executeDequeueInteraction(AQDequeueInteractionSpec spec, AQRecord input, AQRecord output) throws ResourceException {
        try {
            AQQueue queue = this.connection.getSession().getQueue(spec.getSchema(), spec.getQueue());
            AQDequeueOption dequeueOption = spec.getOptions();
            if (dequeueOption == null) {
                dequeueOption = new AQDequeueOption();
            }
            AQMessage message = queue.dequeue(dequeueOption);
            output.add(message.getRawPayload().getBytes());
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString());
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResourceWarning getWarnings() {
        return null;
    }
}

