/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.sbs.ant.taskdefs;

import com.nokia.helium.core.ant.types.Variable;
import com.nokia.helium.core.ant.types.VariableSet;
import com.nokia.helium.core.plexus.AntStreamConsumer;
import com.nokia.helium.sbs.SAXSysdefParser;
import com.nokia.helium.sbs.SBSCommandBase;
import com.nokia.helium.sbs.SBSException;
import com.nokia.helium.sbs.ant.types.SBSInput;
import com.nokia.helium.sbs.ant.types.SBSMakeOptions;
import com.nokia.helium.sbs.plexus.SBSErrorStreamConsumer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PatternSet;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SBSTask
extends Task {
    private Logger log = Logger.getLogger(SBSTask.class);
    private String sbsInputName;
    private String layerPatternSetRef;
    private File sysDefFile;
    private File workingDir;
    private File errorFile;
    private String logSuffix;
    private String cleanLog;
    private String whatLog;
    private String outputLogName;
    private File statsLog;
    private boolean executeCmd = true;
    private boolean failOnError = true;
    private boolean addMakeOptions = true;
    private Date startTime;
    private Date endTime;
    private SBSCommandBase sbsCmd = new SBSCommandBase();

    public SBSCommandBase getSbsCmd() {
        return this.sbsCmd;
    }

    public void setCleanLog(String logPath) {
        this.cleanLog = logPath;
    }

    public void setWhatLog(String logPath) {
        this.whatLog = logPath;
    }

    public String getWhatLog() {
        return this.whatLog;
    }

    public String getCleanLog() {
        return this.cleanLog;
    }

    public void setOutputLog(String logName) {
        this.outputLogName = logName;
    }

    public String getOutputLog() {
        return this.outputLogName;
    }

    public void setStatsLog(File log) {
        this.statsLog = log;
    }

    public File getStatsLog() {
        return this.statsLog;
    }

    public void setSBSInput(String inputName) {
        this.sbsInputName = inputName;
    }

    public String getSBSInput() {
        return this.sbsInputName;
    }

    public void setErrorOutput(File file) {
        this.errorFile = file;
    }

    public File getErrorOutput() {
        return this.errorFile;
    }

    public void setSysDefFile(File file) {
        this.sysDefFile = file;
    }

    public File getSysDefFile() {
        return this.sysDefFile;
    }

    public void setLogSuffix(String suffix) {
        this.logSuffix = suffix;
    }

    public String getLogSuffix() {
        return this.logSuffix;
    }

    public void setLayerPatternSetRef(String id) {
        this.layerPatternSetRef = id;
    }

    public String getLayerPatternSetRef() {
        return this.layerPatternSetRef;
    }

    public void setWorkingDir(File dir) {
        this.workingDir = dir;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setExecute(boolean execute) {
        this.executeCmd = execute;
    }

    public boolean getExecute() {
        return this.executeCmd;
    }

    public void setFailOnError(boolean failBuild) {
        this.failOnError = failBuild;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    protected void setAddMakeOptions(boolean addMakeOptions) {
        this.addMakeOptions = addMakeOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        SBSErrorStreamConsumer sbsErrorConsumer = null;
        this.validateParameter();
        this.sbsCmd.setWorkingDir(this.workingDir);
        if (this.cleanLog != null) {
            this.sbsCmd.setCleanLogFilePath(this.cleanLog);
        }
        if (this.whatLog != null) {
            this.sbsCmd.setWhatLogFilePath(this.whatLog);
        }
        try {
            this.log.debug((Object)("error stream file : " + this.errorFile));
            this.sbsCmd.addOutputLineHandler((StreamConsumer)new AntStreamConsumer((Task)this));
            if (this.errorFile == null) {
                this.log.debug((Object)"redirecting error to Antstream");
                this.sbsCmd.addErrorLineHandler((StreamConsumer)new AntStreamConsumer((Task)this));
            } else {
                sbsErrorConsumer = new SBSErrorStreamConsumer(this.errorFile);
                this.log.debug((Object)"redirecting error to file stream");
                this.sbsCmd.addErrorLineHandler((StreamConsumer)sbsErrorConsumer);
            }
        }
        catch (FileNotFoundException ex) {
            this.log.info((Object)("file path: " + this.errorFile + "Not valid"));
        }
        this.startTime = new Date();
        try {
            this.log("sbs commands: " + this.getSBSCmdLine());
            if (this.executeCmd) {
                this.sbsCmd.execute(this.getSBSCmdLine());
            }
        }
        catch (SBSException sex) {
            this.log.debug((Object)"SBS exception occured during sbs execution", (Throwable)sex);
            if (this.failOnError) {
                throw new BuildException("exception during SBS execution", (Throwable)sex);
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"Exception occured during sbs execution", (Throwable)ex);
            if (this.failOnError) {
                throw new BuildException("exception during SBS execution", (Throwable)ex);
            }
        }
        finally {
            if (sbsErrorConsumer != null) {
                sbsErrorConsumer.close();
            }
        }
        this.endTime = new Date();
        if (this.statsLog != null) {
            this.updateSBSLogStatistics(this.statsLog, this.outputLogName, this.startTime, this.endTime);
        }
    }

    private List<String> getFilteredLayers() {
        ArrayList<String> filteredLayers = null;
        if (this.layerPatternSetRef != null) {
            Hashtable references = this.getProject().getReferences();
            Object layerPatternSetObject = references.get(this.layerPatternSetRef);
            if (layerPatternSetObject != null && !(layerPatternSetObject instanceof PatternSet)) {
                throw new BuildException("Layer Pattern set is not of type PatternSet");
            }
            if (layerPatternSetObject != null) {
                PatternSet layerPatternSet = (PatternSet)layerPatternSetObject;
                SAXSysdefParser sysDefParser = new SAXSysdefParser(this.sysDefFile);
                List<String> fullLayerList = sysDefParser.getLayers();
                filteredLayers = new ArrayList<String>();
                String[] includes = layerPatternSet.getIncludePatterns(this.getProject());
                String[] excludes = layerPatternSet.getExcludePatterns(this.getProject());
                if (includes == null && excludes == null) {
                    throw new BuildException("No patterns specified");
                }
                for (String layer : fullLayerList) {
                    if (includes == null) {
                        if (this.isExcluded(layer, excludes)) continue;
                        filteredLayers.add(layer);
                        continue;
                    }
                    if (!this.isIncluded(layer, includes) || this.isExcluded(layer, excludes)) continue;
                    filteredLayers.add(layer);
                }
            }
        }
        return filteredLayers;
    }

    protected void updateSBSLogStatistics(File infoFileName, String logFileName, Date startTime, Date endTime) {
        try {
            DocumentBuilderFactory sbsInfo = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = sbsInfo.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("sbsinfo");
            doc.appendChild(root);
            Element child = doc.createElement("logfile");
            child.setAttribute("name", logFileName);
            root.appendChild(child);
            long timeDiff = (endTime.getTime() - startTime.getTime()) / 1000L;
            child = doc.createElement("durationlong");
            child.setAttribute("time", "" + timeDiff);
            root.appendChild(child);
            child = doc.createElement("duration");
            int hours = (int)(timeDiff / 3600L);
            int minutesSeconds = (int)(timeDiff % 3600L);
            int minutes = minutesSeconds / 60;
            int seconds = minutesSeconds % 60;
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMinimumIntegerDigits(2);
            String duration = decimalFormat.format(hours) + "H:" + decimalFormat.format(minutes) + "M:" + decimalFormat.format(seconds) + "S";
            child.setAttribute("time", duration);
            root.appendChild(child);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            FileWriter sbsWriter = new FileWriter(infoFileName);
            StreamResult result = new StreamResult(sbsWriter);
            DOMSource sbsSource = new DOMSource(doc);
            transformer.transform(sbsSource, result);
        }
        catch (Exception ex) {
            this.log.debug((Object)"exception while xml writing sbs log info", (Throwable)ex);
        }
    }

    private boolean isIncluded(String text, String[] includes) {
        if (includes != null) {
            for (String pattern : includes) {
                if (!text.matches(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExcluded(String text, String[] excludes) {
        if (excludes != null) {
            for (String pattern : excludes) {
                if (!text.matches(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    protected void validateParameter() {
        if (this.getSBSInput() == null) {
            throw new BuildException("'sbsInputName' is not defined");
        }
        if (this.getSysDefFile() == null) {
            throw new BuildException("'System Definition' file is missing");
        }
        if (this.getWorkingDir() == null) {
            throw new BuildException("'workingDir' must be set");
        }
        if (this.getOutputLog() == null) {
            throw new BuildException("'OutputLog' must be set");
        }
    }

    protected String getSBSCmdLine() {
        List<String> filteredLayers = this.getFilteredLayers();
        Object refObject = this.getProject().getReferences().get(this.sbsInputName);
        if (refObject == null) {
            throw new BuildException("invalid sbs input reference: " + this.sbsInputName);
        }
        if (refObject != null && !(refObject instanceof SBSInput)) {
            throw new BuildException("sbs input name " + this.sbsInputName + "is not valid");
        }
        SBSInput sbsInput = (SBSInput)((Object)refObject);
        StringBuffer cmdOptions = new StringBuffer();
        VariableSet sbsOptions = sbsInput.getFullSBSOptions();
        cmdOptions.append(" -s " + this.sysDefFile);
        Collection variableList = sbsOptions.getVariables();
        if (sbsOptions != null && variableList.isEmpty()) {
            throw new BuildException("sbsoptions cannot be empty for input: " + this.sbsInputName);
        }
        for (Variable variable : variableList) {
            if (variable.getParameter().startsWith("--logfile")) {
                cmdOptions.append(" --logfile " + this.getOutputLog());
                continue;
            }
            cmdOptions.append(" " + variable.getParameter());
        }
        SBSMakeOptions sbsMakeOptions = sbsInput.getFullSBSMakeOptions();
        variableList = null;
        if (sbsMakeOptions != null && this.addMakeOptions) {
            cmdOptions.append(" -e " + sbsMakeOptions.getEngine());
            String ppThreads = sbsMakeOptions.getPPThreads();
            if (ppThreads != null) {
                cmdOptions.append(" -j " + ppThreads);
            }
            variableList = sbsMakeOptions.getVariables();
            for (Variable variable : variableList) {
                cmdOptions.append(" --mo=");
                cmdOptions.append(variable.getParameter());
            }
        }
        if (filteredLayers != null) {
            if (filteredLayers.isEmpty()) {
                this.log("Warning: No matching layers to build from system definition file, skipped");
                return null;
            }
            for (String layer : filteredLayers) {
                cmdOptions.append(" -l " + layer);
            }
        }
        return cmdOptions.toString();
    }
}

