/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.daemon;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.impl.services.daemon.ServiceRecord;

public class BasicDaemon
implements DaemonService,
Runnable {
    private int numClients;
    private static final int OPTIMAL_QUEUE_SIZE = 100;
    private final Vector subscription;
    protected final ContextService contextService;
    protected final ContextManager contextMgr;
    private final List highPQ;
    private final List normPQ;
    private int nextService;
    private boolean awakened;
    private boolean waiting;
    private boolean inPause;
    private boolean running;
    private boolean stopRequested;
    private boolean stopped;
    private long lastServiceTime;
    private int earlyWakeupCount;

    public BasicDaemon(ContextService contextService) {
        this.contextService = contextService;
        this.contextMgr = contextService.newContextManager();
        this.subscription = new Vector(1, 1);
        this.highPQ = new LinkedList();
        this.normPQ = new LinkedList();
        this.lastServiceTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int subscribe(Serviceable serviceable, boolean bl) {
        int n;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            n = this.numClients++;
            ServiceRecord serviceRecord = new ServiceRecord(serviceable, bl, true);
            this.subscription.insertElementAt(serviceRecord, n);
        }
        return n;
    }

    public void unsubscribe(int n) {
        if (n < 0 || n > this.subscription.size()) {
            return;
        }
        this.subscription.setElementAt(null, n);
    }

    public void serviceNow(int n) {
        if (n < 0 || n > this.subscription.size()) {
            return;
        }
        ServiceRecord serviceRecord = (ServiceRecord)this.subscription.elementAt(n);
        if (serviceRecord == null) {
            return;
        }
        serviceRecord.called();
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(Serviceable serviceable, boolean bl) {
        int n;
        ServiceRecord serviceRecord = new ServiceRecord(serviceable, false, false);
        List list = bl ? this.highPQ : this.normPQ;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            list.add(serviceRecord);
            n = this.highPQ.size();
        }
        if (bl && !this.awakened) {
            this.wakeUp();
        }
        if (bl) {
            return n > 100;
        }
        return false;
    }

    public synchronized void clear() {
        this.normPQ.clear();
        this.highPQ.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceRecord nextAssignment(boolean bl) {
        ServiceRecord serviceRecord;
        while (this.nextService < this.subscription.size()) {
            if ((serviceRecord = (ServiceRecord)this.subscription.elementAt(this.nextService++)) == null || !serviceRecord.needImmediateService() && (bl || !serviceRecord.needService())) continue;
            return serviceRecord;
        }
        serviceRecord = null;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            if (!this.highPQ.isEmpty()) {
                serviceRecord = (ServiceRecord)this.highPQ.remove(0);
            }
        }
        if (bl || serviceRecord != null) {
            return serviceRecord;
        }
        serviceRecord = null;
        basicDaemon = this;
        synchronized (basicDaemon) {
            if (!this.normPQ.isEmpty()) {
                serviceRecord = (ServiceRecord)this.normPQ.remove(0);
            }
        }
        return serviceRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceClient(ServiceRecord serviceRecord) {
        serviceRecord.serviced();
        Serviceable serviceable = serviceRecord.client;
        if (serviceable == null) {
            return;
        }
        ContextManager contextManager = this.contextMgr;
        try {
            int n = serviceable.performWork(contextManager);
            if (serviceRecord.subscriber) {
                return;
            }
            if (n == 2) {
                List list = serviceable.serviceASAP() ? this.highPQ : this.normPQ;
                BasicDaemon basicDaemon = this;
                synchronized (basicDaemon) {
                    list.add(serviceRecord);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            contextManager.cleanupOnError(throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.contextService.setCurrentContextManager(this.contextMgr);
        while (!this.stopRequested()) {
            boolean bl = this.rest();
            if (this.stopRequested()) break;
            if (this.inPause()) continue;
            this.work(bl);
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.running = false;
            this.stopped = true;
        }
        this.contextMgr.cleanupOnError(StandardException.normalClose());
        this.contextService.resetCurrentContextManager(this.contextMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.inPause = true;
            while (this.running) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.inPause = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.stopped) {
            return;
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.stopRequested = true;
            this.notifyAll();
        }
        this.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilQueueIsEmpty() {
        while (true) {
            BasicDaemon basicDaemon = this;
            synchronized (basicDaemon) {
                boolean bl = true;
                for (int i = 0; i < this.subscription.size(); ++i) {
                    ServiceRecord serviceRecord = (ServiceRecord)this.subscription.elementAt(i);
                    if (serviceRecord == null || !serviceRecord.needService()) continue;
                    bl = false;
                    break;
                }
                if (this.highPQ.isEmpty() && bl && !this.running) {
                    return;
                }
                this.notifyAll();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized boolean stopRequested() {
        return this.stopRequested;
    }

    private synchronized boolean inPause() {
        return this.inPause;
    }

    protected synchronized void wakeUp() {
        if (!this.awakened) {
            this.awakened = true;
            if (this.waiting) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rest() {
        long l;
        boolean bl;
        boolean bl2 = false;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            try {
                if (!this.awakened) {
                    this.waiting = true;
                    this.wait(10000L);
                    this.waiting = false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.nextService = 0;
            bl = this.awakened;
            if (bl && this.earlyWakeupCount++ > 20) {
                this.earlyWakeupCount = 0;
                bl2 = true;
            }
            this.awakened = false;
        }
        if (bl2 && (l = System.currentTimeMillis()) - this.lastServiceTime > 10000L) {
            this.lastServiceTime = l;
            bl = false;
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    private void work(boolean var1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void yield() {
        Thread thread = Thread.currentThread();
        int n = thread.getPriority();
        if (n <= 1) {
            thread.yield();
        } else {
            ModuleFactory moduleFactory = Monitor.getMonitor();
            if (moduleFactory != null) {
                moduleFactory.setThreadPriority(1);
            }
            thread.yield();
            if (moduleFactory != null) {
                moduleFactory.setThreadPriority(n);
            }
        }
    }
}

