/*
 * Decompiled with CFR 0.152.
 */
package fmpp.progresslisteners;

import fmpp.Engine;
import fmpp.ProgressListener;
import fmpp.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class ConsoleProgressListener
implements ProgressListener {
    private final PrintWriter out;
    private int maxPathLength = 56;
    private boolean quiet;

    public ConsoleProgressListener() {
        this(System.out);
    }

    public ConsoleProgressListener(OutputStream out) {
        this(new PrintWriter(out, true));
    }

    public ConsoleProgressListener(PrintWriter out) {
        this.out = out;
    }

    public ConsoleProgressListener(OutputStream out, boolean quiet) {
        this(new PrintWriter(out, true));
        this.quiet = quiet;
    }

    public ConsoleProgressListener(PrintWriter out, boolean quiet) {
        this.out = out;
        this.quiet = quiet;
    }

    public void notifyProgressEvent(Engine engine, int event, File src, int pMode, Throwable error, Object param) {
        switch (event) {
            case 2: 
            case 7: {
                if (this.quiet) break;
                if (event == 7) {
                    this.out.print("- Not modified: ");
                } else if (pMode == 1) {
                    this.out.print("- Executing: ");
                } else if (pMode == 2) {
                    this.out.print("- Copying: ");
                } else if (pMode == 4) {
                    this.out.print("- Rendering XML: ");
                } else if (pMode == 3) {
                    this.out.print("- Ignoring: ");
                } else {
                    this.out.print("- ???: ");
                }
                try {
                    this.out.println(FileUtil.compressPath(FileUtil.getRelativePath(engine.getSourceRoot(), src), this.maxPathLength));
                }
                catch (IOException exc) {
                    this.out.println("???");
                }
                break;
            }
            case 3: {
                if (error == null) break;
                if (!this.quiet) {
                    this.out.println("  !!! FAILED");
                    break;
                }
                if (engine.getStopOnError()) break;
                this.out.print("! Error with ");
                try {
                    this.out.print(FileUtil.getRelativePath(engine.getSourceRoot(), src));
                }
                catch (IOException exc) {
                    this.out.print("???");
                }
                this.out.println(": " + error);
                break;
            }
            case 6: {
                if (!this.quiet) {
                    this.out.println("  * Warning: " + (String)param);
                    break;
                }
                this.out.print("* Warning from ");
                try {
                    this.out.print(FileUtil.getRelativePath(engine.getSourceRoot(), src));
                }
                catch (IOException exc) {
                    this.out.print("???");
                }
                this.out.println(": " + (String)param);
                break;
            }
            case 5: {
                if (this.quiet) break;
                this.out.print("- Ignoring directory: ");
                try {
                    this.out.println(FileUtil.compressPath(FileUtil.getRelativePath(engine.getSourceRoot(), src), this.maxPathLength));
                }
                catch (IOException exc) {
                    this.out.println("???");
                }
                break;
            }
        }
    }
}

