/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.checks.AbstractCheck;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class CheckScriptSize
extends AbstractCheck {
    @Override
    public void run(Element node) {
        if (node.getName().equals("target")) {
            this.checkSizeOfScript(node);
        }
    }

    private void checkSizeOfScript(Element node) {
        String target = node.attributeValue("name");
        List statements = node.selectNodes("//target[@name='" + target + "']/script | //target[@name='" + target + "']/*[name()=\"hlm:python\"]");
        for (Node statement : statements) {
            int size = statement.getText().length();
            if (size <= 1000) continue;
            this.log("Target " + target + " has a script with " + size + " characters, code should be inside a python file");
        }
    }
}

