/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;

public class ModuleRules {
    private Map rules = new LinkedHashMap();

    public void defineRule(MapMatcher condition, Object rule) {
        Checks.checkNotNull(condition, "condition");
        Checks.checkNotNull(rule, "rule");
        this.rules.put(condition, rule);
    }

    public Object getRule(ModuleRevisionId mrid) {
        return this.getRule(mrid, NoFilter.INSTANCE);
    }

    public Object getRule(ModuleId mid, Filter filter) {
        Checks.checkNotNull(mid, "mid");
        return this.getRule(new ModuleRevisionId(mid, "", ""), filter);
    }

    public Object getRule(ModuleRevisionId mrid, Filter filter) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(filter, "filter");
        Iterator iter = this.rules.keySet().iterator();
        while (iter.hasNext()) {
            Object rule;
            MapMatcher midm = (MapMatcher)iter.next();
            if (!midm.matches(mrid.getAttributes()) || !filter.accept(rule = this.rules.get(midm))) continue;
            return rule;
        }
        return null;
    }

    public void dump(String prefix) {
        if (this.rules.isEmpty()) {
            Message.debug(prefix + "NONE");
        } else {
            Iterator iter = this.rules.keySet().iterator();
            while (iter.hasNext()) {
                MapMatcher midm = (MapMatcher)iter.next();
                Object rule = this.rules.get(midm);
                Message.debug(prefix + midm + " -> " + rule);
            }
        }
    }
}

