/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.logger.ant.listener;

import com.nokia.helium.logger.ant.listener.BuildStatusReport;
import com.nokia.helium.logger.ant.listener.Handler;
import com.nokia.helium.logger.ant.types.Stage;
import com.nokia.helium.logger.ant.types.StageSummary;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.InvalidReferenceException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.util.DateUtils;

public class StageSummaryHandler
implements Handler {
    public static final String PASSED = "PASSED";
    public static final String FAILED = "FAILED";
    private Logger log = Logger.getLogger(this.getClass());
    private boolean displaySummary;
    private boolean lookup4Stages;
    private boolean summarize;
    private List<BuildStatusReport> statusReports = new ArrayList<BuildStatusReport>();
    private HashSet<String> completedStages = new HashSet();
    private Hashtable<String, Stage> currentStages = new Hashtable();
    private Hashtable<String, Long> currentStagesStartTime = new Hashtable();
    private Hashtable<String, Stage> stages;
    private File template;

    public StageSummaryHandler() {
        this.log.debug((Object)"StageStatusHandler instantiated");
    }

    @Override
    public void handleBuildStarted(BuildEvent buildEvent) {
    }

    @Override
    public void handleBuildFinished(BuildEvent buildEvent) {
        if (this.summarize && !this.currentStages.isEmpty()) {
            Long l = this.getCurrentTime();
            String string = this.getReason(buildEvent.getException());
            Hashtable<String, Stage> hashtable = new Hashtable<String, Stage>(this.currentStages);
            for (String string2 : hashtable.keySet()) {
                this.endCurrentStage(string2, (Stage)((Object)hashtable.get(string2)), string, l);
            }
        }
        if (this.summarize && this.displaySummary) {
            this.generateSummary(buildEvent.getProject());
            this.displaySummary = false;
            this.log.debug((Object)"Stage Summary generation completed");
        }
    }

    @Override
    public void handleTargetStarted(BuildEvent buildEvent) {
        Object object;
        Project project = buildEvent.getProject();
        if (!this.summarize) {
            object = this.getStageSummary(project);
            this.lookup4Stages = this.summarize = object != null && object.getTemplate() != null;
            this.template = object.getTemplate();
            this.log.debug((Object)("Is Project configured to display Stage Summary ? " + this.summarize));
        }
        if (this.lookup4Stages) {
            this.log.debug((Object)"Loading stages....");
            this.parseStages(buildEvent.getProject());
            this.log.debug((Object)("Total no of stages loaded = " + this.stages.size()));
            this.lookup4Stages = false;
        }
        this.log.debug((Object)("Handling target - " + buildEvent.getTarget().getName()));
        if (this.summarize) {
            object = this.getCurrentTime();
            TreeMap<String, Stage> treeMap = this.searchNewStage(buildEvent);
            if (treeMap != null && treeMap.size() == 1) {
                String string = treeMap.firstKey();
                Stage stage = treeMap.get(string);
                this.startNewStage(string, stage, (Long)object);
            }
        }
    }

    @Override
    public void handleTargetFinished(BuildEvent buildEvent) {
        TreeMap<String, Stage> treeMap;
        String string = buildEvent.getTarget().getName();
        Long l = this.getCurrentTime();
        String string2 = this.getReason(buildEvent.getException());
        if (this.summarize && !this.currentStages.isEmpty() && !(treeMap = this.getCurrentStageToEnd(string)).isEmpty()) {
            String string3 = treeMap.firstKey();
            Stage stage = treeMap.get(string3);
            this.endCurrentStage(string3, stage, string2, l);
        }
    }

    private TreeMap<String, Stage> getCurrentStageToEnd(String string) {
        TreeMap<String, Stage> treeMap = new TreeMap<String, Stage>();
        for (String string2 : this.currentStages.keySet()) {
            Stage stage = this.currentStages.get(string2);
            if (!stage.isEndTarget(string)) continue;
            treeMap.put(string2, stage);
            break;
        }
        return treeMap;
    }

    private StageSummary getStageSummary(Project project) {
        StageSummary stageSummary = null;
        int n = 0;
        Hashtable hashtable = project.getReferences();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object v = hashtable.get(enumeration.nextElement());
            if (!(v instanceof StageSummary)) continue;
            if (++n > 1) {
                this.raiseException("Multiple entries of 'hlm:stagesummary' found in stages_config.ant.xml.");
            }
            stageSummary = (StageSummary)((Object)v);
        }
        return stageSummary;
    }

    private void raiseException(String string) {
        throw new BuildException(string);
    }

    private void startNewStage(String string, Stage stage, Long l) {
        if (!this.currentStages.containsKey(string)) {
            this.currentStages.put(string, stage);
            this.currentStagesStartTime.put(string, l);
            this.log.debug((Object)("New stage [" + string + "] started at " + this.getTimestamp(l)));
        }
    }

    private void endCurrentStage(String string, Stage stage, String string2, Long l) {
        if (stage != null) {
            BuildStatusReport buildStatusReport = this.constructBuildStatusReport(string, this.currentStagesStartTime.get(string), l, string2);
            this.statusReports.add(buildStatusReport);
            this.displaySummary = true;
            this.log.debug((Object)("Stage [" + string + "] finished at " + this.getTimestamp(l)));
            this.reset(string);
        }
    }

    private void reset(String string) {
        this.currentStages.remove(string);
        this.currentStagesStartTime.remove(string);
        this.completedStages.add(string);
    }

    private TreeMap<String, Stage> searchNewStage(BuildEvent buildEvent) {
        TreeMap<String, Stage> treeMap = new TreeMap<String, Stage>();
        String string = buildEvent.getTarget().getName();
        for (String string2 : this.stages.keySet()) {
            Stage stage = this.stages.get(string2);
            if (this.completedStages.contains(string2) || !this.isStartingTarget(string, buildEvent.getProject(), stage)) continue;
            treeMap.put(string2, stage);
            break;
        }
        return treeMap;
    }

    private boolean isStartingTarget(String string, Project project, Stage stage) {
        Vector vector;
        boolean bl = false;
        if (project.getTargets().containsKey(stage.getStartTarget()) && !(vector = project.topoSort(stage.getStartTarget(), project.getTargets(), false)).isEmpty()) {
            Target target = (Target)vector.firstElement();
            bl = target.getName().equals(string);
        }
        return bl;
    }

    private void parseStages(Project project) {
        this.stages = new Hashtable();
        Hashtable hashtable = project.getReferences();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (!(v instanceof Stage)) continue;
            this.validateStageInformation(string, (Stage)((Object)v));
            this.stages.put(string, (Stage)((Object)v));
        }
    }

    private String getReason(Throwable throwable) {
        return throwable != null ? throwable.getMessage() : "";
    }

    private Long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private void generateSummary(Project project) {
        if (this.template != null) {
            try {
                Configuration configuration = new Configuration();
                this.log.debug((Object)("Basedir: " + this.template.getParentFile()));
                configuration.setTemplateLoader((TemplateLoader)new FileTemplateLoader(this.template.getParentFile()));
                Template template = configuration.getTemplate(this.template.getName());
                StringWriter stringWriter = new StringWriter();
                template.process(this.getTemplateData(), (Writer)stringWriter);
                project.log(stringWriter.toString());
            }
            catch (InvalidReferenceException invalidReferenceException) {
                project.log("Invalid reference in config: ", (Throwable)invalidReferenceException, 1);
            }
            catch (TemplateException templateException) {
                project.log("TemplateException: ", (Throwable)templateException, 1);
            }
            catch (IOException iOException) {
                project.log("I/O Error during template conversion: " + iOException.toString(), 1);
            }
        }
    }

    private Map<String, Object> getTemplateData() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("statusReports", new ArrayList<BuildStatusReport>(this.statusReports));
        return hashMap;
    }

    private String getTimestamp(long l) {
        Date date = new Date(l);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        String string = dateFormat.format(date);
        return string;
    }

    private String getTimeElapsed(Long l, Long l2) {
        long l3 = l2 - l;
        return DateUtils.formatElapsedTime((long)l3);
    }

    private BuildStatusReport constructBuildStatusReport(String string, Long l, Long l2, String string2) {
        return new BuildStatusReport(string, this.getTimestamp(l), this.getTimeElapsed(l, l2), string2);
    }

    private void validateStageInformation(String string, Stage stage) {
        if (stage.getStartTarget() == null) {
            throw new BuildException("'starttarget' for stage '" + string + "' should not be null.");
        }
        if (stage.getEndTarget() == null) {
            throw new BuildException("'endtarget' for stage '" + string + "' should not be null.");
        }
    }
}

