/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.util;

import info.bliki.wiki.tags.util.AbstractNode;
import info.bliki.wiki.tags.util.Attribute;
import info.bliki.wiki.tags.util.NodeAttribute;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiTagNode
extends AbstractNode {
    private static final long serialVersionUID = -5135255005207719745L;
    private static final String[] NONE = new String[0];
    protected List<NodeAttribute> mAttributes;

    public WikiTagNode() {
        this(-1, -1, new ArrayList<NodeAttribute>());
    }

    public WikiTagNode(int start, int end, ArrayList<NodeAttribute> attributes) {
        super(start, end);
        this.mAttributes = attributes;
        if (this.mAttributes == null || this.mAttributes.size() == 0) {
            String[] names = this.getIds();
            if (names != null && names.length != 0) {
                this.setTagName(names[0]);
            } else {
                this.setTagName("");
            }
        } else {
            this.setTagName(((Attribute)this.mAttributes.get(0)).getName());
        }
    }

    public String getAttribute(String name) {
        String ret = null;
        NodeAttribute attribute = this.getAttributeEx(name);
        if (attribute != null) {
            ret = attribute.getValue();
        }
        return ret;
    }

    public void setAttribute(String key, String value) {
        char quote;
        char ch;
        int i;
        boolean needed = false;
        boolean singleq = true;
        boolean doubleq = true;
        if (value != null) {
            i = 0;
            while (i < value.length()) {
                ch = value.charAt(i);
                if (Character.isWhitespace(ch)) {
                    needed = true;
                } else if ('\'' == ch) {
                    singleq = false;
                } else if ('\"' == ch) {
                    doubleq = false;
                }
                ++i;
            }
        }
        if (needed) {
            if (doubleq) {
                quote = '\"';
            } else if (singleq) {
                quote = '\'';
            } else {
                quote = '\"';
                String ref = "&quot;";
                StringBuffer buffer = new StringBuffer(value.length() * 5);
                i = 0;
                while (i < value.length()) {
                    ch = value.charAt(i);
                    if (quote == ch) {
                        buffer.append(ref);
                    } else {
                        buffer.append(ch);
                    }
                    ++i;
                }
                value = buffer.toString();
            }
        } else {
            quote = '\u0000';
        }
        NodeAttribute attribute = this.getAttributeEx(key);
        if (attribute != null) {
            attribute.setValue(value);
            if (quote != '\u0000') {
                attribute.setQuote(quote);
            }
        } else {
            this.setAttribute(key, value, quote);
        }
    }

    public void removeAttribute(String key) {
        NodeAttribute attribute = this.getAttributeEx(key);
        if (attribute != null) {
            this.getAttributesEx().remove(attribute);
        }
    }

    public void setAttribute(String key, String value, char quote) {
        this.setAttribute(new NodeAttribute(key, value, quote));
    }

    public NodeAttribute getAttributeEx(String name) {
        NodeAttribute ret = null;
        List<NodeAttribute> attributes = this.getAttributesEx();
        if (attributes != null) {
            int size = attributes.size();
            int i = 0;
            while (i < size) {
                NodeAttribute attribute = attributes.get(i);
                String string = attribute.getName();
                if (string != null && name.equalsIgnoreCase(string)) {
                    ret = attribute;
                    i = size;
                }
                ++i;
            }
        }
        return ret;
    }

    public void setAttributeEx(NodeAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setAttribute(NodeAttribute attribute) {
        boolean replaced = false;
        List<NodeAttribute> attributes = this.getAttributesEx();
        int length = attributes.size();
        if (length > 0) {
            String name = attribute.getName();
            int i = 1;
            while (i < attributes.size()) {
                Attribute test = attributes.get(i);
                String test_name = test.getName();
                if (test_name != null && test_name.equalsIgnoreCase(name)) {
                    attributes.set(i, attribute);
                    replaced = true;
                }
                ++i;
            }
        }
        if (!replaced) {
            if (length != 0 && !attributes.get(length - 1).isWhitespace()) {
                attributes.add(new NodeAttribute(" "));
            }
            attributes.add(attribute);
        }
    }

    public List<NodeAttribute> getAttributesEx() {
        return this.mAttributes;
    }

    public String getTagName() {
        String ret = this.getRawTagName();
        if (ret != null) {
            if ((ret = ret.toLowerCase()).startsWith("/")) {
                ret = ret.substring(1);
            }
            if (ret.endsWith("/")) {
                ret = ret.substring(0, ret.length() - 1);
            }
        }
        return ret;
    }

    public String getRawTagName() {
        String ret = null;
        List<NodeAttribute> attributes = this.getAttributesEx();
        if (attributes.size() != 0) {
            ret = attributes.get(0).getName();
        }
        return ret;
    }

    public void setTagName(String name) {
        NodeAttribute attribute = new NodeAttribute(name, null, '\u0000');
        List<NodeAttribute> attributes = this.getAttributesEx();
        if (attributes == null) {
            attributes = new ArrayList<NodeAttribute>();
            this.setAttributesEx(attributes);
        }
        if (attributes.size() == 0) {
            attributes.add(attribute);
        } else {
            Attribute zeroth = attributes.get(0);
            if (zeroth.getValue() == null && zeroth.getQuote() == '\u0000') {
                attributes.set(0, attribute);
            } else {
                attributes.add(0, attribute);
            }
        }
    }

    @Override
    public String getText() {
        String ret = this.toHtml();
        ret = ret.substring(1, ret.length() - 1);
        return ret;
    }

    public void setAttributesEx(List<NodeAttribute> attribs) {
        this.mAttributes = attribs;
    }

    public void setTagBegin(int tagBegin) {
        this.nodeBegin = tagBegin;
    }

    public int getTagBegin() {
        return this.nodeBegin;
    }

    public void setTagEnd(int tagEnd) {
        this.nodeEnd = tagEnd;
    }

    public int getTagEnd() {
        return this.nodeEnd;
    }

    @Override
    public String toPlainTextString() {
        return "";
    }

    @Override
    public String toHtml(boolean verbatim) {
        NodeAttribute attribute;
        int length = 2;
        List<NodeAttribute> attributes = this.getAttributesEx();
        int size = attributes.size();
        int i = 0;
        while (i < size) {
            attribute = attributes.get(i);
            length += attribute.getLength();
            ++i;
        }
        StringBuilder ret = new StringBuilder(length);
        ret.append("<");
        i = 0;
        while (i < size) {
            attribute = attributes.get(i);
            attribute.toString(ret);
            if (i < size - 1) {
                ret.append(" ");
            }
            ++i;
        }
        ret.append(">");
        return ret.toString();
    }

    public boolean isEmptyXmlTag() {
        Attribute attribute;
        String name;
        boolean ret = false;
        List<NodeAttribute> attributes = this.getAttributesEx();
        int size = attributes.size();
        if (size > 0 && (name = (attribute = (Attribute)attributes.get(size - 1)).getName()) != null) {
            int length = name.length();
            ret = name.charAt(length - 1) == '/';
        }
        return ret;
    }

    public void setEmptyXmlTag(boolean emptyXmlTag) {
        List<NodeAttribute> attributes = this.getAttributesEx();
        int size = attributes.size();
        if (size > 0) {
            NodeAttribute attribute = attributes.get(size - 1);
            String name = attribute.getName();
            if (name != null) {
                int length = name.length();
                String value = attribute.getValue();
                if (value == null) {
                    if (name.charAt(length - 1) == '/') {
                        if (!emptyXmlTag) {
                            if (1 == length) {
                                attributes.remove(size - 1);
                            } else {
                                name = name.substring(0, length - 1);
                                attribute = new NodeAttribute(name, null);
                                attributes.remove(size - 1);
                                attributes.add(attribute);
                            }
                        }
                    } else if (emptyXmlTag) {
                        attribute = new NodeAttribute(" ");
                        attributes.add(attribute);
                        attribute = new NodeAttribute("/", null);
                        attributes.add(attribute);
                    }
                } else if (emptyXmlTag) {
                    attribute = new NodeAttribute(" ");
                    attributes.add(attribute);
                    attribute = new NodeAttribute("/", null);
                    attributes.add(attribute);
                }
            } else if (emptyXmlTag) {
                attribute = new NodeAttribute("/", null);
                attributes.add(attribute);
            }
        } else if (emptyXmlTag) {
            NodeAttribute attribute = new NodeAttribute("/", null);
            attributes.add(attribute);
        }
    }

    public boolean isEndTag() {
        String raw = this.getRawTagName();
        return raw == null ? false : raw.length() != 0 && '/' == raw.charAt(0);
    }

    public String[] getIds() {
        return NONE;
    }

    public String[] getEnders() {
        return NONE;
    }

    public String[] getEndTagEnders() {
        return NONE;
    }
}

