/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dynamic;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.schemaframework.DynamicSchemaManager;

public class DynamicHelper {
    private DatabaseSession session;

    public DynamicHelper(DatabaseSession session) {
        this.session = session;
    }

    public DatabaseSession getSession() {
        return this.session;
    }

    public DynamicType getType(String typeName) {
        ClassDescriptor cd = this.getSession().getClassDescriptorForAlias(typeName);
        if (cd == null) {
            return null;
        }
        return DynamicHelper.getType(cd);
    }

    public static DynamicType getType(ClassDescriptor descriptor) {
        return (DynamicType)descriptor.getProperty("ENTITY_TYPE");
    }

    public static DynamicType getType(DynamicEntity entity) throws ClassCastException {
        return ((DynamicEntityImpl)entity).getType();
    }

    public void removeType(String typeName) {
        DynamicType type = this.getType(typeName);
        if (type != null) {
            this.getSession().getIdentityMapAccessor().initializeIdentityMap(type.getJavaClass());
            ClassDescriptor descriptor = type.getDescriptor();
            this.getSession().getProject().getOrderedDescriptors().remove(descriptor);
            this.getSession().getProject().getDescriptors().remove(type.getJavaClass());
        }
    }

    public DynamicEntity newDynamicEntity(String typeName) {
        DynamicType type = this.getType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("DynamicHelper.createQuery: Dynamic type not found: " + typeName);
        }
        return type.newDynamicEntity();
    }

    public ReadAllQuery newReadAllQuery(String typeName) {
        DynamicType type = this.getType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("DynamicHelper.createQuery: Dynamic type not found: " + typeName);
        }
        return new ReadAllQuery(type.getJavaClass());
    }

    public ReadObjectQuery newReadObjectQuery(String typeName) {
        DynamicType type = this.getType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("DynamicHelper.createQuery: Dynamic type not found: " + typeName);
        }
        return new ReadObjectQuery(type.getJavaClass());
    }

    public ReportQuery newReportQuery(String typeName, ExpressionBuilder builder) {
        DynamicType type = this.getType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("DynamicHelper.createQuery: Dynamic type not found: " + typeName);
        }
        return new ReportQuery(type.getJavaClass(), builder);
    }

    public DynamicClassLoader getDynamicClassLoader() {
        return DynamicClassLoader.lookup(this.getSession());
    }

    public void addTypes(boolean createMissingTables, boolean generateFKConstraints, DynamicType ... types) {
        if (types == null || types.length == 0) {
            throw new IllegalArgumentException("No types provided");
        }
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>(types.length);
        for (int index = 0; index < types.length; ++index) {
            descriptors.add(types[index].getDescriptor());
            if (types[index].getDescriptor().requiresInitialization()) continue;
            types[index].getDescriptor().getInstantiationPolicy().initialize((AbstractSession)((Object)this.session));
        }
        this.session.addDescriptors(descriptors);
        if (createMissingTables) {
            if (!this.getSession().isConnected()) {
                this.getSession().login();
            }
            new DynamicSchemaManager(this.session).createTables(generateFKConstraints, types);
        }
    }

    public static class SessionCustomizer
    implements org.eclipse.persistence.config.SessionCustomizer {
        public void customize(Session session) throws Exception {
            DynamicClassLoader dcl = DynamicClassLoader.lookup(session);
            Iterator i = session.getProject().getDescriptors().values().iterator();
            while (i.hasNext()) {
                new DynamicTypeBuilder(dcl, (ClassDescriptor)i.next(), null);
            }
        }
    }
}

