/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.ant.data;

import com.nokia.helium.ant.data.AntObjectMeta;
import com.nokia.helium.ant.data.TaskContainerMeta;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;

public class TargetMeta
extends TaskContainerMeta {
    public TargetMeta(AntObjectMeta parent, Node node) throws IOException {
        super(parent, node);
    }

    public String getIf() {
        return this.getAttr("if");
    }

    public String getUnless() {
        return this.getAttr("unless");
    }

    public String getDescription() {
        return this.getAttr("description");
    }

    @Override
    public String getSummary() {
        String summary = super.getSummary();
        if (summary.length() == 0) {
            summary = this.getDescription();
        }
        return summary;
    }

    public List<String> getDepends() {
        String dependsAttr = this.getAttr("depends");
        StringTokenizer st = new StringTokenizer(dependsAttr, ",");
        ArrayList<String> depends = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            depends.add(st.nextToken().trim());
        }
        return depends;
    }

    @Override
    public List<String> getSignals() {
        List<String> signals = super.getSignals();
        List<String> additionalSignals = this.getDatabase().getSignals(this.getName());
        if (additionalSignals != null) {
            signals.addAll(additionalSignals);
        }
        return signals;
    }

    public List<String> getPropertyDependencies() {
        ArrayList<String> properties = new ArrayList<String>();
        AntPropertyVisitor visitor = new AntPropertyVisitor(properties);
        this.getNode().accept((Visitor)visitor);
        return properties;
    }

    private class AntPropertyVisitor
    extends VisitorSupport {
        private List<String> propertyList;

        public AntPropertyVisitor(List<String> propertyList) {
            this.propertyList = propertyList;
        }

        public void visit(Attribute node) {
            String text = node.getStringValue();
            this.extractUsedProperties(text);
        }

        public void visit(CDATA node) {
            String text = node.getText();
            this.extractUsedProperties(text);
        }

        public void visit(Text node) {
            String text = node.getText();
            this.extractUsedProperties(text);
        }

        public void visit(Element node) {
            String propertyName;
            if (node.getName().equals("property") && (propertyName = node.attributeValue("name")) != null && !this.propertyList.contains(propertyName)) {
                this.propertyList.add(propertyName);
                TargetMeta.this.log("property matches :" + propertyName, 4);
            }
        }

        private void extractUsedProperties(String text) {
            Pattern p1 = Pattern.compile("\\$\\{([^@$}]*)\\}");
            Matcher m1 = p1.matcher(text);
            TargetMeta.this.log(text, 4);
            while (m1.find()) {
                String group = m1.group(1);
                if (!this.propertyList.contains(group)) {
                    this.propertyList.add(group);
                }
                TargetMeta.this.log("property matches: " + group, 4);
            }
            Pattern p2 = Pattern.compile("\\$\\{([^\n]*\\})\\}");
            Matcher m2 = p2.matcher(text);
            TargetMeta.this.log(text, 4);
            while (m2.find()) {
                String group = m2.group(1);
                if (!this.propertyList.contains(group)) {
                    this.propertyList.add(group);
                }
                TargetMeta.this.log("property matches: " + group, 4);
            }
            Pattern p3 = Pattern.compile("\\$\\{(\\@\\{[^\n]*)\\}");
            Matcher m3 = p3.matcher(text);
            TargetMeta.this.log(text, 4);
            while (m3.find()) {
                String group = m3.group(1);
                if (!this.propertyList.contains(group)) {
                    this.propertyList.add(group);
                }
                TargetMeta.this.log("property matches: " + group, 4);
            }
        }
    }
}

