/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.logger.ant.listener;

import com.nokia.helium.logger.ant.listener.BuildEventHandler;
import com.nokia.helium.logger.ant.listener.MessageEventHandler;
import com.nokia.helium.logger.ant.listener.StatusAndLogListener;
import com.nokia.helium.logger.ant.listener.TargetEventHandler;
import com.nokia.helium.logger.ant.listener.TaskEventHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.StringUtils;

public class RecorderEntry
implements BuildEventHandler,
TargetEventHandler,
TaskEventHandler,
MessageEventHandler {
    private File filename;
    private boolean record = true;
    private int loglevel = 2;
    private PrintStream out;
    private long targetStartTime;
    private boolean emacsMode;
    private Pattern pattern;
    private Vector<String> logRegExps = new Vector();
    private Logger log = Logger.getLogger(this.getClass());

    public RecorderEntry(File file) {
        this.targetStartTime = System.currentTimeMillis();
        this.filename = file;
    }

    public File getFilename() {
        return this.filename;
    }

    public void setRecordState(boolean bl) {
        this.flush();
        this.record = bl;
    }

    public boolean getRecordState() {
        return this.record;
    }

    public void addRegexp(String string) {
        this.logRegExps.add(string);
    }

    public void resetRegExp() {
        this.logRegExps.clear();
    }

    @Override
    public void handleBuildStarted(BuildEvent buildEvent) {
        this.log("> BUILD STARTED", 4);
    }

    @Override
    public void handleBuildFinished(BuildEvent buildEvent) {
        this.log.debug((Object)"< BUILD FINISHED");
        if (this.record && this.out != null) {
            Throwable throwable = buildEvent.getException();
            if (throwable == null) {
                this.out.println(StringUtils.LINE_SEP + "BUILD SUCCESSFUL");
            } else {
                this.out.println(StringUtils.LINE_SEP + "BUILD FAILED" + StringUtils.LINE_SEP);
                throwable.printStackTrace(this.out);
            }
        }
        this.cleanup();
    }

    public void handleSubBuildFinished(BuildEvent buildEvent) {
        this.log("< SUBBUILD FINISHED", 4);
    }

    public void handleSubBuildStarted(BuildEvent buildEvent) {
        this.log("< SUBBUILD STARTED", 4);
    }

    @Override
    public void handleTargetStarted(BuildEvent buildEvent) {
        this.log(">> TARGET STARTED -- " + buildEvent.getTarget(), 4);
        this.log(StringUtils.LINE_SEP + buildEvent.getTarget().getName() + ":", 2);
        this.targetStartTime = System.currentTimeMillis();
    }

    @Override
    public void handleTargetFinished(BuildEvent buildEvent) {
        this.log("<< TARGET FINISHED -- " + buildEvent.getTarget(), 4);
        String string = RecorderEntry.formatTime(System.currentTimeMillis() - this.targetStartTime);
        this.log(buildEvent.getTarget() + ":  duration " + string, 3);
        this.flush();
    }

    @Override
    public void handleTaskStarted(BuildEvent buildEvent) {
        this.log(">>> TASK STARTED -- " + buildEvent.getTask(), 4);
    }

    @Override
    public void handleTaskFinished(BuildEvent buildEvent) {
        this.log("<<< TASK FINISHED -- " + buildEvent.getTask(), 4);
        this.flush();
    }

    @Override
    public void handleMessageLogged(BuildEvent buildEvent) {
        String string;
        this.log("--- MESSAGE LOGGED", 4);
        StringBuffer stringBuffer = new StringBuffer();
        if (buildEvent.getTask() != null) {
            string = buildEvent.getTask().getTaskName();
            if (!this.emacsMode) {
                String string2 = "[" + string + "] ";
                int n = 12 - string2.length();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string2);
            }
        }
        string = this.filterMessage(buildEvent.getMessage());
        stringBuffer.append(string);
        this.log(stringBuffer.toString(), buildEvent.getPriority());
    }

    private String filterMessage(String string) {
        for (String string2 : this.logRegExps) {
            this.pattern = Pattern.compile(string2);
            if (this.pattern == null) continue;
            Matcher matcher = this.pattern.matcher(string);
            string = matcher.replaceAll("********");
        }
        return string;
    }

    private void log(String string, int n) {
        if (this.record && n <= this.loglevel && this.out != null) {
            this.out.println(string);
        }
    }

    private void flush() {
        if (this.record && this.out != null) {
            this.out.flush();
        }
    }

    public void setMessageOutputLevel(int n) {
        if (n >= 0 && n <= 4) {
            this.loglevel = n;
        }
    }

    public void setOutputPrintStream(PrintStream printStream) {
        this.closeFile();
        this.out = printStream;
    }

    public void setEmacsMode(boolean bl) {
        this.emacsMode = bl;
    }

    public void setErrorPrintStream(PrintStream printStream) {
        this.setOutputPrintStream(printStream);
    }

    private static String formatTime(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        if (l3 > 0L) {
            return Long.toString(l3) + " minute" + (l3 == 1L ? " " : "s ") + Long.toString(l2 % 60L) + " second" + (l2 % 60L == 1L ? "" : "s");
        }
        return Long.toString(l2) + " second" + (l2 % 60L == 1L ? "" : "s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        StatusAndLogListener statusAndLogListener = StatusAndLogListener.getStatusAndLogListener();
        if (statusAndLogListener != null) {
            this.log.debug((Object)"register");
            StatusAndLogListener statusAndLogListener2 = statusAndLogListener;
            synchronized (statusAndLogListener2) {
                statusAndLogListener.register(this);
                statusAndLogListener.register(this);
                statusAndLogListener.register(this);
                statusAndLogListener.register(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        StatusAndLogListener statusAndLogListener = StatusAndLogListener.getStatusAndLogListener();
        if (statusAndLogListener != null) {
            this.log.debug((Object)"unregister");
            StatusAndLogListener statusAndLogListener2 = statusAndLogListener;
            synchronized (statusAndLogListener2) {
                statusAndLogListener.remove(this);
                statusAndLogListener.remove(this);
                statusAndLogListener.remove(this);
                statusAndLogListener.remove(this);
            }
        }
    }

    public void cleanup() {
        this.closeFile();
    }

    public void closeFile() {
        this.log.debug((Object)"closeFile.");
        if (this.out != null) {
            this.out.close();
            this.out = null;
            this.unregister();
        }
    }

    public void openFile(boolean bl) {
        this.openFileImpl(bl);
    }

    public void reopenFile() {
        this.openFileImpl(true);
    }

    private void openFileImpl(boolean bl) {
        if (this.out == null) {
            this.log.debug((Object)("openFileImpl: " + this.filename));
            try {
                this.out = new PrintStream(new FileOutputStream(this.filename, bl));
                this.register();
            }
            catch (IOException iOException) {
                throw new BuildException("Problems opening file using a recorder entry: " + iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    public void addLogMessage(String string) {
        this.out.println(StringUtils.LINE_SEP + string);
    }
}

