/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.regexp.MatchSuppressor;
import com.puppycrawl.tools.checkstyle.checks.regexp.NeverSuppress;
import java.util.regex.Pattern;

class DetectorOptions {
    private final int mCompileFlags;
    private final AbstractViolationReporter mReporter;
    private String mFormat;
    private String mMessage = "";
    private int mMinimum;
    private int mMaximum;
    private boolean mIgnoreCase;
    private MatchSuppressor mSuppressor = NeverSuppress.INSTANCE;

    public DetectorOptions(int aCompileFlags, AbstractViolationReporter aReporter) {
        this.mCompileFlags = aCompileFlags;
        this.mReporter = aReporter;
    }

    public DetectorOptions setFormat(String aFormat) {
        this.mFormat = aFormat;
        return this;
    }

    public DetectorOptions setMessage(String aMessage) {
        this.mMessage = aMessage;
        return this;
    }

    public DetectorOptions setMinimum(int aMinimum) {
        this.mMinimum = aMinimum;
        return this;
    }

    public DetectorOptions setMaximum(int aMaximum) {
        this.mMaximum = aMaximum;
        return this;
    }

    public DetectorOptions setSuppressor(MatchSuppressor aSup) {
        this.mSuppressor = aSup;
        return this;
    }

    public DetectorOptions setIgnoreCase(boolean aIgnore) {
        this.mIgnoreCase = aIgnore;
        return this;
    }

    public String getFormat() {
        return this.mFormat;
    }

    public AbstractViolationReporter getReporter() {
        return this.mReporter;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public int getMinimum() {
        return this.mMinimum;
    }

    public int getMaximum() {
        return this.mMaximum;
    }

    public MatchSuppressor getSuppressor() {
        return this.mSuppressor;
    }

    public boolean isIgnoreCase() {
        return this.mIgnoreCase;
    }

    public Pattern getPattern() {
        int options = this.mIgnoreCase ? this.mCompileFlags | 2 : this.mCompileFlags;
        return Utils.getPattern(this.mFormat, options);
    }
}

