/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2005/10/07 15:27:58 $
 * $Revision: 1.9.2.1 $
 */

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <TCHAR.H>

#include <ansi_parms.h>

_MSL_BEGIN_EXTERN_C			

#if UNICODE
#define __msl_tsystem_core 	__msl_wsystem_core
#define __msl_tputenv 		__msl_wputenv
#define _tgetenv			_wgetenv
#else
#define __msl_tsystem_core 	__msl_system_core
#define __msl_tputenv		__msl_putenv
#define _tgetenv			getenv
#endif

/*	Core functionality for system(), exec() routines.  
	'comspec' is set to shell to use (or 0L for direct launch),
	'cmdLine' is full Win32 command line,
	'envp' is NULL-terminated array of environment variables "var=value" or NULL for none,
	'crFlags' is bitmask of flags for new process.
	Returns 0 for success or -1 for failure.
	Fills in 'piProcInfo' with new process handle/thread. 
*/
int _MSL_CDECL __msl_tsystem_core(const _TCHAR *comspec, const _TCHAR * cmdLine, const _TCHAR *const *envp,
						DWORD crFlags, PROCESS_INFORMATION *piProcInfo);

/*	Define/redefine/delete an environment setting. */
int _MSL_CDECL __msl_tputenv(const _TCHAR * varSetting);

_MSL_IMP_EXP_C _TCHAR * _MSL_CDECL					_tgetenv(const _TCHAR *) _MSL_CANT_THROW;
_MSL_IMP_EXP_C int _MSL_CDECL						_tsystem(const _TCHAR *) _MSL_CANT_THROW;

_MSL_END_EXTERN_C	

/* Change record:
 * ejs 011119 Added this file.
 * ejs 030721 Added UNICODE support
 */