/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:49 $
 * $Revision: 1.11 $
 */

/*
 *	Content:	Interface file to standard UNIX-style entry points ...
 *
 *	NB:			This file implements some UNIX low level support.  These functions
 *				are not guaranteed to be 100% conformant.
 */

#include <stdlib.h>
#include <io.h> 				
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <crtl.h>
#include <fcntl.h>
#include <extras.h>
#include <errno.h>


/*
 *	int _setmode(int handle, int mode)
 *
 *		Changes the file translation mode to binary or text
 *
 */
 
int _setmode(int handle, int mode) _MSL_CANT_THROW
{
	int oldmode;									
 	FILE * infile = &__files[0];
	
	/* check to see if handle passed in is valid */
	if (handle >= NUM_HANDLES || !_HandleTable[handle])
	{
		errno = EBADF;
        return -1;
	}
	
	/* look for any FILE* using this handle */
	while (infile)
	{
		if (handle == infile->handle)
			break;
		infile = infile->next_file_struct;
	}
	
	if (_HandleTable[handle]->translate)
		oldmode = O_TEXT;
	else
		oldmode = O_BINARY;
	
	if (mode == O_BINARY)
	{
		if (infile)
			infile->mode.binary_io = 1;
		
		_HandleTable[handle]->translate = 0;
		
		return oldmode;
	}	
	else if (mode == O_TEXT )
	{
		if (infile)
			infile->mode.binary_io = 0;
		
		_HandleTable[handle]->translate = 1;
		
		return oldmode;

	}
	else
	{
		errno = EINVAL;
		return -1;
	}
}

/*
 *	int open(const char *path, int flags)
 *
 *		Opens a file stream.
 */
  
 
int _MSL_CDECL open(const char *path, int flags,...) _MSL_CANT_THROW
{
    return __msl_open(path,flags);
}


/*
 *	int creat(char *path, mode_t mode)
 *
 *		Creates and opens a file.
 */
int _MSL_CDECL creat(const char *path, mode_t mode) _MSL_CANT_THROW
{
	int				omode = O_WRONLY | O_CREAT | O_TRUNC;

	if (mode & O_BINARY)
		omode |= O_BINARY;

	return (open(path, omode));
}


/*
 *	int fcntl(int fildes, int cmd, ...)
 *
 *		General file control routines.
 */
int _MSL_CDECL fcntl(int fildes, int cmd, ...) _MSL_CANT_THROW
{
	if (cmd == F_DUPFD) {
		/* we don't support this one correctly but it does conform */
		/* just return the same file descriptor as the one passed to it */
		int __new_handle = _dup(fildes);				/*- cc 000710 -*/
		return (__new_handle);							/*- cc 000710 -*/
	}

	return (-1);
}

#pragma mark -

#if _MSL_WFILEIO_AVAILABLE

int _MSL_CDECL _wopen(const wchar_t *path, int flags, ...) _MSL_CANT_THROW
{
    return __msl_wopen(path,flags);
}

int _MSL_CDECL _wcreat(const wchar_t *path, mode_t mode) _MSL_CANT_THROW
{
	int omode = O_WRONLY | O_CREAT | O_TRUNC;

	if (mode & O_BINARY)
		omode |= O_BINARY;

	return (_wopen(path, omode));
}

#endif /* _MSL_WFILEIO_AVAILABLE */


/* Change record:
 * JH  951210 Modified to interface with new ANSI C library
 * JH  951215 Removed SetupExit call
 * JH  951230 Removed uses of OLDROUTINENAMES
 * KO  960312 Very minor changes to stop compiler warnings.
 * hh  980122 Replaced <windows.h> with the following TWO includes because it is seriously
 *            broken.  The following 2 includes must be carefully ordered as shown, because
 *            they are broken too.
 * mm  980507 Changes to revert from _open, _creat, and _fcntl to open, creat, fcntl while 
 *            accommodating legacy code.  MW01597
 * mf  980518 x86_prefix is included by ansi_prefix.win32.h and should not be included by
 *            wince(runs off the intel architecture).
 * mm  980710 Changed signature for open() to match specification in POSIX standard
 * mm  980724 Corrected mapping of open modes to match POSIX specification
 * vss 980825 Restored previous logic to open modes - fixed a problem with
 *            not truncating existing files when opened with "w" permission
 * vss 980825 Restored C style comments 
 * vss 990129 Add O_EXCL to O_CREAT flags
 * mm  990204 Reject O_EXCL without O_CREAT and give O_TRUNC precedence over O_APPEND
 * mm  991210 Prevent truncating when opening O_RDWR O_CREAT   
 * cc  000518 fixed #include 
 * mm  000524 Made it possible to have the same named file open twice to two different streams 
 * cc  000710 fixed fcntl so that you can use F_DUPFD and get a duplicate file handle
 * cc  010601 Created a __msl_open equivalent to open - MSL C in dependent of open/msl_open
 * cc  010605 Removed dummy prototype of GetHandle and added extras.h
 * cc  011203 Added _MSL_CDECL for new name mangling 
 * cc  020628 Added _setmode
 * JWW 021010 Added wchar_t file I/O routines controlled by _MSL_WFILEIO_AVAILABLE
 */