/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:50 $
 * $Revision: 1.6 $
 */

#include <errno.h>
#include <stdio.h>
#include <stdio.posix.h>
#include <ansi_files.h>


/*
 *	FILE *fdopen(int handle, char *mode)
 *
 *		Converts a file handle into an ANSI C file stream.
 */
FILE * _MSL_CDECL fdopen(int handle, const char *mode) _MSL_CANT_THROW
{
	/* The Mac version of this routine makes sure that the requested		*/
	/* mode can be granted given the permissions of the handle.  Currently	*/
	/* this routine doesn't do that check.									*/
	
	FILE * theFileP = __find_unopened_file();
	
	if (!theFileP)
		return(0);
	
	return(__handle_reopen(handle, mode, theFileP));
}

/* Change record:
 * KO  961031 Wrote fdopen. Previously it was an empty definition.
 * mf  980622 got rid of un-needed header files
 * cc  000210 moved _tell and __myraise and headers to extras.c  
 * cc  000215 added _chmod
 * cc  000517 cleaned up #includes
 * mm  010122 Made second parameter to _fdopen const char* to match POSIX standard.
 * cc  010622 Made _chmod into chmod
 * JWW 010927 Renamed from unix.win32.c to stdio_posix.win32.c
 * cc  011203 Added _MSL_CDECL for new name mangling 
 */