static void *libc=0;


#include <alloca.h>
#include <stdarg.h>

#ifndef __USE_GNU
#define __USE_GNU
#endif
#include <dlfcn.h>


#ifndef FDOUT
#define FDOUT 5
#endif

int write(int,const void *,int);
char *strcpy(char*, const char*);
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "config.h"

#define log(s,mode) {const char *c; \
		     for(c=mode;*c;c++)write(FDOUT,c,1); \
		     write(FDOUT," ",1); \
                     for(c=s;*c;c++)write(FDOUT,c,1);\
		     write(FDOUT,"\n",1);}
		     

#ifdef RTLD_NEXT   

#define SET(ret,name,args) \
  static ret (*_FUNC_) args= 0; \
  if (_FUNC_ == 0) { \
    _FUNC_ = (ret(*)args) dlsym(RTLD_NEXT, name); \
  }

#else

#ifndef LIBC
#define LIBC "libc.so"
#endif

#define SET(ret,name,args) \
  static ret (*_FUNC_) args= 0; \
  if (_FUNC_ == 0) { \
    _FUNC_ = (ret(*)args) dlsym(libc, name); \
  }

void _init() {
  libc = dlopen(LIBC, RTLD_LAZY|RTLD_GLOBAL);  
}

void _fini() {
  dlclose (libc);
}
#endif

/*************************************************************/
/*                                                           */
/*  CREAT                                                    */
/*                                                           */
/*************************************************************/
int                     creat(const char *fname, mode_t mode)
{
  int                     ret;

  SET(int,"creat",(const char *fname, mode_t mode));
  ret = _FUNC_(fname, mode);
  if (ret > 0) {
    log(fname,"w");
  }
  return ret;
}

#ifdef HAVE_OPEN64
int                     creat64(const char *fname, mode_t mode)
{
  int                     ret;

  SET(int,"creat64",(const char *fname, mode_t mode));
  ret = _FUNC_(fname, mode);
  if (ret > 0) {
    log(fname,"w");
  }
  return ret;
}
#endif

/*************************************************************/
/*                                                           */
/*  OPEN                                                     */
/*                                                           */
/*************************************************************/
int                     open(const char *fname, int mode,...)
{
  va_list                 list;
  int                     ret;
  int                     perm;

  SET(int,"open",(const char *fname, int mode,...));
  va_start(list, mode);
  perm = va_arg(list, int);
  ret = _FUNC_(fname, mode, perm);
  va_end(list);
  if (ret > 0) {
    char modet[5];
    if ((mode & 3) == 0 ) strcpy(modet,"r");
    if ((mode & 3) == 1 ) strcpy(modet,"w");
    if ((mode & 3) == 2 ) strcpy(modet,"w+");
    
    
    log(fname,modet);
  }
  return ret;
}

#ifdef HAVE_OPEN64
int                     open64(const char *fname, int mode,...)
{
  va_list                 list;
  int                     ret;
  int                     perm;

  SET(int,"open64",(const char *fname, int mode,...));
  va_start(list, mode);
  perm = va_arg(list, int);
  ret = _FUNC_(fname, mode, perm);
  va_end(list);
  if (ret > 0) {
    char modet[5];
    if ((mode & 3) == 0 ) strcpy(modet,"r");
    if ((mode & 3) == 1 ) strcpy(modet,"w");
    if ((mode & 3) == 2 ) strcpy(modet,"w+");
    
    
    log(fname,modet);
  }
  return ret;
}
#endif

/*************************************************************/
/*                                                           */
/*  FREOPEN                                                  */
/*                                                           */
/*************************************************************/
void* freopen(const char *fname, const char  *mode,  void *stream)
{
  void* ret;
  SET(void*,"freopen",(const char *filename, const char  *mode,  void *stream));
  ret =  _FUNC_(fname, mode,stream);
  
  if (ret != 0) {
    log(fname,mode);
  }
  return ret;
}

#ifdef HAVE_OPEN64
void* freopen64(const char *fname, const char  *mode,  void *stream)
{
  void* ret;

  SET(void*,"freopen64",(const char *filename, const char  *mode,  void *stream));
  ret =  _FUNC_(fname, mode,stream);
  
  if (ret != 0) {
    log(fname,mode);
  }
  return ret;
}
#endif

/*************************************************************/
/*                                                           */
/*  FOPEN                                                    */
/*                                                           */
/*************************************************************/
void                     *fopen(const char *fname, const char *mode)
{
  void *ret;
  
  SET(void*,"fopen",(const char *fname, const char *mode));
  ret = _FUNC_(fname, mode);

  if (ret != 0) {
    log(fname,mode);
  }
  return ret;
}

#ifdef HAVE_OPEN64
void                     *fopen64(const char *fname, const char *mode)
{
  void *ret;

  SET(void*,"fopen64",(const char *fname, const char *mode));

  ret = _FUNC_(fname, mode);

  if (ret != 0) {
    log(fname,mode);
  }
  return ret;
}
#endif

/*************************************************************/
/*                                                           */
/*  UNLINK                                                   */
/*                                                           */
/*************************************************************/
int                     unlink(const char *fname)
{
  int                     ret;

  SET(int,"unlink",(const char *fname));
  
  ret = _FUNC_(fname);

  if (ret == 0) {
    log(fname,"u");
  }
  return ret;
}

#ifdef HAVE_OPEN64
int                     unlink64(const char *fname)
{
  int                     ret;

  SET(int,"unlink64",(const char *fname));

  ret = _FUNC_(fname);

  if (ret == 0) {
    log(fname,"u");
  }
  return ret;
}
#endif

/*************************************************************/
/*                                                           */
/*  RENAME                                                   */
/*                                                           */
/*************************************************************/
int rename(const char *oldpath, const char *newpath) {

  int                     ret;

  SET(int,"rename",(const char *oldpath, const char *newpath));

  ret = _FUNC_(oldpath,newpath);

  if (ret == 0) {
    log(oldpath,"r");
    log(newpath,"w");
    log(oldpath,"u");
  }
  return ret;
}

/*************************************************************/
/*                                                           */
/*  EXEC  (Not USED YET)                                     */
/*                                                           */
/*************************************************************/
#ifdef EXEC
int                     execl(const char *path, const char *arg,...)
{
  size_t                  argv_max = 1024;
  const char            **argv = (const char **) alloca(argv_max * sizeof(const char *));
  unsigned int            i;
  va_list                 args;
  SET(int,"execv",(const char *path, char *const * argv));

  argv[0] = arg;

  va_start(args, arg);
  i = 0;
  while (argv[i++] != 0) {
    if (i == argv_max) {
      const char            **nptr = (const char **) alloca((argv_max *= 2) * sizeof(const char *));

#ifndef _STACK_GROWS_UP
      if ((char *) nptr + argv_max == (char *) argv) {
	/* Stack grows down.  */
	argv = (const char **) memcpy(nptr, argv, i);
	argv_max += i;
      } else
#endif

#ifndef _STACK_GROWS_DOWN
      if ((char *) argv + i == (char *) nptr)
	/* Stack grows up.  */
	argv_max += i;
      else
#endif

	/* We have a hole in the stack.  */
	argv = (const char **) memcpy(nptr, argv, i);
    }
    argv[i] = va_arg(args, const char *);
  }
  va_end(args);
  log(path,"x");
  return _FUNC_(path,(char *const *)argv);
}

int                     execle(const char *path, const char *arg,...)
{
  size_t                  argv_max = 1024;
  const char            **argv = (const char **) alloca(argv_max * sizeof(const char *));
  const char             *const * envp;
  unsigned int            i;
  va_list                 args;

  SET(int,"execve",(const char *path, char *const * argv, char *const * envp));

  argv[0] = arg;

  va_start(args, arg);
  i = 0;
  while (argv[i++] != 0) {
    if (i == argv_max) {
      const char            **nptr = (const char **) alloca((argv_max *= 2) * sizeof(const char *));

#ifndef _STACK_GROWS_UP
      if ((char *) nptr + argv_max == (char *) argv) {
	/* Stack grows down.  */
	argv = (const char **) memcpy(nptr, argv, i);
	argv_max += i;
      } else
#endif

#ifndef _STACK_GROWS_DOWN
      if ((char *) argv + i == (char *) nptr)
	/* Stack grows up.  */
	argv_max += i;
      else
#endif

	/* We have a hole in the stack.  */
	argv = (const char **) memcpy(nptr, argv, i);
    }
    argv[i] = va_arg(args, const char *);
  }

  envp = va_arg(args, const char *const *);
  va_end(args);

  log(path,"x");
  return _FUNC_(path, (char *const *) argv, (char *const *) envp);
}

int                     execlp(const char *file, const char *arg,...)
{
  size_t                  argv_max = 1024;
  const char            **argv = (const char **) alloca(argv_max * sizeof(const char *));
  unsigned int            i;
  va_list                 args;
  SET(int,"execvp",(const char *file, char *const * argv));

  argv[0] = arg;

  va_start(args, arg);
  i = 0;
  while (argv[i++] != 0) {
    if (i == argv_max) {
      const char            **nptr = (const char **) alloca((argv_max *= 2) * sizeof(const char *));

#ifndef _STACK_GROWS_UP
      if ((char *) nptr + argv_max == (char *) argv) {
	/* Stack grows down.  */
	argv = (const char **) memcpy(nptr, argv, i);
	argv_max += i;
      } else
#endif

#ifndef _STACK_GROWS_DOWN
      if ((char *) argv + i == (char *) nptr)
	/* Stack grows up.  */
	argv_max += i;
      else
#endif

	/* We have a hole in the stack.  */
	argv = (const char **) memcpy(nptr, argv, i);
    }
    argv[i] = va_arg(args, const char *);
  }
  va_end(args);

  log(file,"x");
  return _FUNC_(file, (char *const *) argv);
}

int                     execv(const char *path, char *const * argv)
{
  SET(int,"execv",(const char *path, char *const * argv));
  log(path,"x");
  return _FUNC_(path, argv);
}


int                     execve(const char *path, char *const * argv, char *const * envp)
{
  SET(int,"execve",(const char *path, char *const * argv, char *const * envp));
  log(path,"x");
  return _FUNC_(path, argv, envp);
}


int                     execvp(const char *file, char *const * argv)
{
  SET(int,"execvp",(const char *file, char *const * argv));
  log(file,"x");
  return _FUNC_(file, argv);
}

#endif /* EXEC */
