/*
	Structured exception handling macros, typedefs, and functions
*/

#ifndef _MSL_EXCPT_H
#define _MSL_EXCPT_H

#include <ansi_parms.h>

#pragma pack(push, 8)

_MSL_BEGIN_EXTERN_C

typedef enum _EXCEPTION_DISPOSITION 
{
	ExceptionContinueExecution = 0,
	ExceptionContinueSearch = 1,
	ExceptionNestedException = 2,
	ExceptionCollidedUnwind = 3
} EXCEPTION_DISPOSITION;


#ifndef __cplusplus
#define try                         __try
#define except                      __except
#define finally                     __finally
#define leave                       __leave
#endif

struct _EXCEPTION_POINTERS;

#define GetExceptionCode            _exception_code
#define exception_code              _exception_code
#define GetExceptionInformation     (struct _EXCEPTION_POINTERS *)_exception_info
#define exception_info              (struct _EXCEPTION_POINTERS *)_exception_info
#define AbnormalTermination         _abnormal_termination
#define abnormal_termination        _abnormal_termination

unsigned long _MSL_CDECL _exception_code(void);
void *        _MSL_CDECL _exception_info(void);
int           _MSL_CDECL _abnormal_termination(void);

/*	__except() expression return values */

#define EXCEPTION_EXECUTE_HANDLER       1
#define EXCEPTION_CONTINUE_SEARCH       0
#define EXCEPTION_CONTINUE_EXECUTION    (-1)
_MSL_END_EXTERN_C


#pragma pack(pop)

#endif //_MSL_EXCPT_H

/*	EJS 050224 Rewrote
 */
