/* Metrowerks x86 Runtime Support Library 
 * Copyright  1995-2001 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2005/02/25 15:39:58 $
 * $Revision: 1.1.2.1 $
 */

#ifndef __X86_PREFIX_H
#define __X86_PREFIX_H

/*
	Defines useful for compiling Windows headers. 
	
	This prefix file is needed when building from a fresh Win32 SDK
	(which is not aware of Codewarrior).  However, most of the necessary
	header changes are already made in the Win32 SDK shipped with 
	CW Professional.
*/

#ifndef _X86_
	#define _X86_
#endif

#ifndef WIN32
	/* same as definition in OLE2.h where 100 implies WinNT version 1.0 */
	#define WIN32 100
#endif

#ifndef _CRTAPI1
	#define _CRTAPI1 __cdecl
#endif

/*
	These sets of macros define the base system the SDK will target.
	If any of these are selected, programs generated may not run on
	previous versions of Windows.
	
	With all of these undefined, the SDK targets Win95 and WinNT 4.0,
	with Internet Explorer 4.
*/

/*
//	target WinNT 4.0
#undef _WIN32_WINNT
#define _WIN32_WINNT 0x0400
#undef WINVER
#define WINVER 0x0400
*/

/*
//	target Win98 or WinNT 4.0
#undef _WIN32_WINNT
#define _WIN32_WINNT 0x0410
#undef WINVER
#define WINVER 0x0400
*/

/*
// 	target Win98 and Win2000
#undef WINVER
#define WINVER 0x0500
*/

/*
//	target Win2000
#undef _WIN32_WINNT
#define _WIN32_WINNT 0x0500
#undef WINVER
#define WINVER 0x0500
*/

/*
//	target Internet Explorer 5 (implied by WINVER==0x0500)
//	(default is IE 4)
#ifndef _WIN32_IE
	#define _WIN32_IE 0x0500
#endif
*/

/* These keywords are built in to MSVC++ */
#ifndef _stdcall
	#define _stdcall __stdcall
#endif
#ifndef _cdecl
	#define _cdecl __cdecl
#endif
#ifndef _asm
	#define _asm asm
#endif
#ifndef _inline
	#define _inline inline
#endif
#ifndef _fastcall
	#define _fastcall __fastcall
#endif

/* these type macros are defined in MSVC++ */
#ifndef __int8
	#define __int8 char
#endif
#ifndef __int16
	#define __int16 short
#endif
#ifndef __int32
	#define __int32 long
#endif
#ifndef __int64
	#define __int64  long long
#endif

/* compiler settings visible in MSVC++ */

#if __option(unsigned_char)
	#define _CHAR_UNSIGNED
#endif

#if __option(RTTI)
	#define _CPPRTTI
#endif

#if __option(exceptions)
	#define _CPPUNWIND
#endif

#ifndef _STDCALL_SUPPORTED
	#define _STDCALL_SUPPORTED
#endif

#ifdef UNICODE
	#ifndef _UNICODE
		#define _UNICODE 1
	#endif
#endif

#ifdef _UNICODE
	#ifndef UNICODE
		#define UNICODE 1
	#endif
#endif

/* REMOVED: */

/* Pro4+ automatically defines _M_IX86 based on processor choice */

/* Pro5+ automatically defines _WIN32 */

/* 
// We're not VC++, so don't define _MSC_VER by default.
// If you want this, uncomment the following #define, or
// alter your sources to check for __MWERKS__, __INTEL__, 
// __option(xxx), etc. to target CodeWarrior.
//
// We mostly implement the feature set of CL 9.0 (MSVC++ 2).
#define _MSC_VER 	0x900
*/

#ifndef DECLSPEC_SELECTANY
#define DECLSPEC_SELECTANY  __declspec(selectany)
#endif

#ifndef DECLSPEC_NOVTABLE
#define DECLSPEC_NOVTABLE __declspec(novtable)
#endif

#ifndef DECLSPEC_UUID
#define DECLSPEC_UUID(x) __declspec(uuid(x))
#endif

#ifndef _PUSHPOP_SUPPORTED
#define _PUSHPOP_SUPPORTED
#endif

#endif /* __X86_PREFIX_H */

/* Change record:
 * cc  010531 Added defines for _MSL_TRUE & _MSL_FALSE for _GetThreadLocalData
 * ejs 030907 Fix typo in comment (_WIN32_WINDOWS)
 */
