#include <stdio.h>
/* lstat */
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

/* ctime */
#include <time.h>

#include "rcs.h"




int rcs_get_version(char *filename,char *version){
  struct stat buf;
  int ret = 1;
  if (lstat(filename,&buf ) == 0) {
    struct tm * date;
    char cmd[256];
      FILE *p;

    date = gmtime(&buf.st_mtime);
    
    sprintf(cmd,"rlog -d\"%04d/%02d/%02d %02d:%02d:%02d\" %s 2>/dev/null",
      	    date->tm_year+1900,date->tm_mon + 1,date->tm_mday,
	    date->tm_hour,date->tm_min,date->tm_sec,
	    filename);

    p = popen(cmd,"r");
    while (fgets(cmd,250,p)) {
     if (sscanf(cmd,"revision %s\n",version)) { ret = 0 ; break;}
    }
    return ret;
  }
  return 1;  
}

int rcs_diff(char *filename,char *version){
  FILE *p;
  char cmd[256];
  sprintf(cmd,"rcsdiff -r%s -q --brief %s 2>/dev/null",version,filename);
  p = popen(cmd,"r");
  fgets(cmd,250,p);
  return pclose(p); /* status is 0 if equal */
}

#ifdef TEST
main (int argc,char ** argv) {
  char version[256];
  
  rcs_get_version(argv[1],version);
  printf("%s:%s %d\n",argv[1],version,rcs_diff(argv[1],version));
}
#endif
