/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.taskdefs;

import com.nokia.ant.taskdefs.CoverageRecorderEntry;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Recorder;

public class CoverageRecorderTask
extends Recorder {
    private static Hashtable recorderEntries = new Hashtable();
    private String filename;
    private Boolean append;
    private Boolean start;
    private int loglevel = -1;
    private boolean emacsMode;

    public void setName(String fname) {
        this.filename = fname;
    }

    public void setAction(Recorder.ActionChoices action) {
        this.start = action.getValue().equalsIgnoreCase("start") ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAppend(boolean append) {
        this.append = append ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public void setLoglevel(Recorder.VerbosityLevelChoices level) {
        this.loglevel = level.getLevel();
    }

    public void execute() {
        if (this.filename == null) {
            throw new BuildException("No filename specified");
        }
        this.getProject().log("setting a recorder for name " + this.filename, 4);
        String recordTaskName = this.getTaskName();
        CoverageRecorderEntry recorder = this.getRecorder(this.filename, this.getProject(), recordTaskName);
        recorder.setMessageOutputLevel(this.loglevel);
        recorder.setEmacsMode(this.emacsMode);
        if (this.start != null) {
            if (this.start.booleanValue()) {
                recorder.setRecordState(this.start);
            } else {
                recorder.setRecordState(this.start);
                recorder.cleanup();
            }
        }
    }

    protected CoverageRecorderEntry getRecorder(String name, Project proj, String recordTaskName) {
        CoverageRecorderEntry entry;
        Object o = recorderEntries.get(name);
        if (o == null) {
            entry = new CoverageRecorderEntry(name, recordTaskName);
            entry.setProject(proj);
            recorderEntries.put(name, entry);
        } else {
            entry = (CoverageRecorderEntry)o;
        }
        return entry;
    }
}

