/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.cruisecontrol.sourcecontrol;

import java.util.List;
import net.sourceforge.cruisecontrol.CruiseControlException;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class XPathMapper {
    private static final Logger LOG = Logger.getLogger(XPathMapper.class);
    private String expression;
    private String value;
    private String name = "";

    public void validate() throws CruiseControlException {
        if (this.name == null) {
            throw new CruiseControlException("'expression' attribute not defined.");
        }
        if (this.expression == null && this.value == null) {
            throw new CruiseControlException("Either 'expression' or 'value' attribute must be defined.");
        }
        if (this.value != null && this.expression != null) {
            throw new CruiseControlException("You can define both attributes 'expression' and 'value'.");
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String extract(Object element) throws CruiseControlException {
        if (this.value != null) {
            return this.value;
        }
        try {
            List nodes = XPath.selectNodes((Object)element, (String)this.getExpression());
            if (nodes.size() > 1) {
                throw new CruiseControlException("'" + this.getExpression() + "' returns several results.");
            }
            if (nodes.size() < 1) {
                throw new CruiseControlException("'" + this.getExpression() + "' does not return any result.");
            }
            Attribute attr = (Attribute)nodes.get(0);
            return attr.getValue();
        }
        catch (JDOMException exc) {
            throw new CruiseControlException("Could not extract data using '" + this.getExpression() + "' " + (Object)((Object)exc));
        }
    }
}

