/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;

final class AccessResult
implements Serializable {
    private static final int CODE_ALLOWED = 10;
    private static final int CODE_DISALLOWED = 20;
    private static final int CODE_UNKNOWN = 30;
    private static final String LABEL_ALLOWED = "ALLOWED";
    private static final String LABEL_DISALLOWED = "DISALLOWED";
    private static final String LABEL_UNKNOWN = "UNKNOWN";
    public static final AccessResult ALLOWED = new AccessResult(10, "ALLOWED");
    public static final AccessResult DISALLOWED = new AccessResult(20, "DISALLOWED");
    public static final AccessResult UNKNOWN = new AccessResult(30, "UNKNOWN");
    private static final Map<String, AccessResult> NAME_TO_LEVEL = Maps.newHashMap();
    private final int mCode;
    private final String mLabel;

    private AccessResult(int aCode, String aLabel) {
        this.mCode = aCode;
        this.mLabel = aLabel.trim();
    }

    String getLabel() {
        return this.mLabel;
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean equals(Object aObj) {
        boolean result = false;
        if (aObj instanceof AccessResult && ((AccessResult)aObj).mCode == this.mCode) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        return this.mCode;
    }

    public static AccessResult getInstance(String aName) {
        String arName = aName.trim();
        AccessResult retVal = NAME_TO_LEVEL.get(arName);
        if (retVal == null) {
            throw new IllegalArgumentException(arName);
        }
        return retVal;
    }

    private Object readResolve() {
        return AccessResult.getInstance(this.mLabel);
    }

    static {
        NAME_TO_LEVEL.put(LABEL_ALLOWED, ALLOWED);
        NAME_TO_LEVEL.put(LABEL_DISALLOWED, DISALLOWED);
        NAME_TO_LEVEL.put(LABEL_UNKNOWN, UNKNOWN);
    }
}

