/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:34 $
 * $Revision: 1.5 $
 */

#pragma pack(push,2)
struct X80
{
  
  long sig[2];
  short exp;
};
 
static const struct X80 powers_of_ten[]={
{{0,0x80000000},0x3FFF},{{0,0xa0000000},0x4002},  //1,10
{{0,0xC8000000},0x4005},{{0,0xFA000000},0x4008},  //100,1000
{{0,0x9C400000},0x400C},{{0,0xC3500000},0x400F},  //1e4
{{0,0xF4240000},0x4012},{{0,0x98968000},0x4016},  //1e6
{{0,0xBEBC2000},0x4019},{{0,0xEE6B2800},0x401C},  //1e8-1e9 
{{0,0x9502F900},0x4020},{{0,0xBA43B740},0x4023},  //1e10-1e11
{{0,0xE8D4A510},0x4026},{{0,0x9184E72A},0x402A},  //1e12-1e13
{{0x80000000,0xB5E620F4},0x402D},{{0xA0000000,0xE35FA931},0x4030}, //1e14-1e15
{{0x04000000,0x8E1BC9BF},0x4034},{{0xC5000000,0xB1A2BC2E},0x4037}, //1e16-1e17
{{0x76400000,0xDE0B6B3A},0x403A},{{0x89E80000,0x8AC72304},0x403E}, //1e18-1e19
{{0xAC620000,0xAD78EBC5},0x4041},{{0x177A8000,0xD8D726B7},0x4044}, //1e20-1e21
{{0x6EAC9000,0x87867832},0x4048},{{0x0A57B400,0xA968163F},0x404B}, //1e22-1e23
{{0xCCEDA100,0xD3C21BCE},0x404E},{{0x401484A0,0x84595161},0x4052}, //1e24-1e25
{{0x9019A5C8,0xA56FA5B9},0x4055},{{0xF4200F3A,0xCECB8F27},0x4058}, //1e26-1e27
{{0xF8940984,0x813F3978},0x405C},{{0x36B90BE5,0xA18F07D7},0x405F}, //1e28-1e29
{{0x04674EDE,0xC9F2C9CD},0x4062},{{0x45812296,0xFC6F7C40},0x4065}  //1e30-1e31
};    
 
static const struct X80 big_powers_of_ten[]={
{{0x2B70B59E , 0x9DC5ADA8}, 0x4069},      //1e32
{{0xFFCFA6D5 , 0xC2781F49}, 0x40D3},      //1e64
{{0xC59B14A3 , 0xEFB3AB16}, 0x413D},      //1e96
{{0x80E98CE0 , 0x93BA47C9}, 0x41A8},      //1e128
{{0x7FE617AB , 0xB616A12B}, 0x4212},      //1e160
{{0x3927556B , 0xE070F78D}, 0x427C},      //1e192
{{0xE33CC930 , 0x8A5296FF}, 0x42E7},      //1e224
{{0x9DF9DE8E , 0xAA7EEBFB}, 0x4351},      //1e256
{{0x5C6A2F8D , 0xD226FC19}, 0x43BB},      //1e288
{{0xF2CCE376 , 0x81842F29}, 0x4426},      //1e320
{{0xDB900AD3 , 0x9FA42700}, 0x4490},      //1e352									
{{0          , 0x80000000}, 0x7fff}       //INFINITY			
} ;

#pragma pack(pop)

/* Change record: 
 * cc  010410 made new change record  
 */