/* Metrowerks x86 Runtime Support Library 
 * Copyright  1995-2003 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2005/01/20 23:06:07 $
 * $Revision: 1.2 $
 */
 
#include <ansi_parms.h> 
#include <stddef.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <crtl.h>
#include <ExceptionX86.h>
#include <ThreadLocalData.h>
#include <abort_exit.h>     /* hh 971207 Added <abort_exit.h> header */
#include <stdlib.h>  /* mf -- for atexit */

extern BOOL __stdcall DllMain(HINSTANCE, DWORD, LPVOID);
static int __proc_attached = 0;

// C++ Exception Tables
static ExceptionTableHeader ExceptionTables =
{
    &_PcToActionStart,
    &_PcToActionEnd,
    0
};

BOOL (WINAPI* _pRawDllMain)(HINSTANCE, DWORD, LPVOID);

// This procedure does C library initialization and cleanup for DLLs. This is called
// automatically when the default DLL entry point is used. Only DLL's using custom
// entry points should call this directly.
// Even though this is named _CRT_INIT, the whole library is initialized; not just the
// run time.
#if UNICODE

#define _tCRT_INIT	_wCRT_INIT

BOOL __stdcall _wCRT_INIT(HINSTANCE, DWORD, LPVOID);
BOOL __stdcall _wCRT_INIT(
	HINSTANCE inst, 
	DWORD fdwReason, 
	LPVOID lpvReserved)

#else

#define _tCRT_INIT	_CRT_INIT

BOOL __stdcall _CRT_INIT(HINSTANCE, DWORD, LPVOID);
BOOL __stdcall _CRT_INIT(
	HINSTANCE inst, 
	DWORD fdwReason, 
	LPVOID lpvReserved)

#endif
{
	switch (fdwReason)
	{
		case DLL_PROCESS_ATTACH:
			asm
			{
				// align the stack
				sub		esp, 0x20
				and		esp, ~0x1f
			}
		
			// Register our exception handling tables
			_RegisterExceptionTables(&ExceptionTables);

			// Start up the runtime system in case it isn't already
			if (!_CRTStartup())
				return 0;
			
			/* Setup the globals __argc and __argv. */
			_tSetupArgs();

			/* Get environment variables */
			_tSetupEnv();

			// Run the constructors for static and global C++ objects.
			_RunInit(&__xc_a);

			// increment flag to indicate process attach notification
			// has been received
			__proc_attached++;

			break;
		case DLL_THREAD_ATTACH:
#ifndef _MSL_BUILDING_DLL
			if (!_InitializeThreadData((void *)GetCurrentThread()))
			{
	        	return 0;		
			}
#endif
			break;
			
		case DLL_THREAD_DETACH:
#ifndef _MSL_BUILDING_DLL
			_DisposeThreadData();
#endif
			break;

		case DLL_PROCESS_DETACH:
			if (__proc_attached > 0)
			{
				__proc_attached--;
				
				// only get rid of these items when the DLL shuts down completely
				if (__proc_attached == 0)
				{
					// destroy local DLL's global chain
					__destroy_global_chain();
					
					// This procedure does all the clean up that exit would do but it
					// doesn't call ExitProcess. Calling ExitProcess would prevent
					// the rest of the process from being able to clean up.
					_CleanUpMSL(&ExceptionTables);

					// Unregister the exception tables
					_UnRegisterExceptionTables(&ExceptionTables);
				}
			}
			break;
			
	}

	// Success.
	return 1;
}

// The default entry point for DLLs.
#if UNICODE

BOOL __stdcall _wDllMainCRTStartup(HINSTANCE, DWORD, LPVOID);
BOOL __stdcall _wDllMainCRTStartup(
	HINSTANCE hDllHandle,
	DWORD dwReason,
	LPVOID lpreserved)
#else

BOOL __stdcall _DllMainCRTStartup(HINSTANCE, DWORD, LPVOID);
BOOL __stdcall _DllMainCRTStartup(
	HINSTANCE hDllHandle,
	DWORD dwReason,
	LPVOID lpreserved)
#endif
{
        BOOL retcode = TRUE;

        /*
         * If this is a process detach notification, check that there has
         * been a prior process attach notification.
         */
        if ((dwReason == DLL_PROCESS_DETACH) && (__proc_attached == 0))
            return FALSE;

        if (dwReason == DLL_PROCESS_ATTACH || dwReason == DLL_THREAD_ATTACH)
        {
            if (_pRawDllMain)
                retcode = (*_pRawDllMain)(hDllHandle, dwReason, lpreserved);

            if (retcode)
                retcode = _tCRT_INIT(hDllHandle, dwReason, lpreserved);

            if (!retcode)
                return FALSE;
        }

        retcode = DllMain(hDllHandle, dwReason, lpreserved);

        if ((dwReason == DLL_PROCESS_ATTACH) && !retcode)
        {
			// The user's DllMain routine returned failure, the C runtime
			// needs to be cleaned up. Do this by calling _CRT_INIT again,
			// this time imitating DLL_PROCESS_DETACH. Note this will also
			// clear the __proc_attached flag so the cleanup will not be
			// repeated upon receiving the real process detach notification.
			_tCRT_INIT(hDllHandle, DLL_PROCESS_DETACH, lpreserved);
		}

        if ((dwReason == DLL_PROCESS_DETACH) ||
			(dwReason == DLL_THREAD_DETACH))
        {
            if (_tCRT_INIT(hDllHandle, dwReason, lpreserved) == FALSE)
                retcode = FALSE;

            if (retcode && _pRawDllMain)
				retcode = (*_pRawDllMain)(hDllHandle, dwReason, lpreserved);
        }

        return retcode;
}
/* Change Record
 * KO  961220  Mostly rewrote this file.
 * hh  971207  Added <abort_exit.h> header
 * hh  971207  Added namespace support
 * hh  971207  Added _CRT_INIT prototype 
 * hh  971207  Added _DllMainCRTStartup prototype
 * blc 990304  Incorporated MFC DLL fixes for multiple MFC users
 * blc 990315  Fixed problems with MFC initialization
 * ejs 000320  Added unhandled exception filter
 * ejs 000819  Don't destroy thread data unless we're MSL
 * mf  000907  added wrapper  _MSL_BUILDING_DLL to PROCESS_DETACH message call to 
 *             _DisposeAllThreadData.  This was causing random crashes in the ide
 *             when a dll would unload through the Free/LoadLibrary call.
 * mf  000908  removed call to DisposeThreadData in   should be in DLL_PROCESS_DETACH.
 *             CleanUPMSL but for now we just assume pool_free_all cleans up this memory.            
 * ejs 010123  removed unhandled exception filter nonsense, added stack alignment
 * hh  010307  Removed explicit calls to _atexit_funcs.  atexit is now merged with the global
 *             destructor chain and calls to __destroy_global_chain() handle this.
 * ejs 011023  Removed exception handler nonsense altogether
 * ejs 011119  Added call to _SetupEnv
 * ejs 011206  Cleanup of init/term code
 * ejs 030721  Added UNICODE startup support 
 * ejs 040517  Make sure __wDllMainCRTStartup@12 can be used to select UNICODE DLL runtime
 */
