/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.sbs.ant.taskdefs;

import com.nokia.helium.core.ant.types.Variable;
import com.nokia.helium.core.ant.types.VariableSet;
import com.nokia.helium.core.plexus.AntStreamConsumer;
import com.nokia.helium.sbs.SBSCommandBase;
import com.nokia.helium.sbs.ant.taskdefs.SBSTask;
import com.nokia.helium.sbs.plexus.CoverityErrorStreamConsumer;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SBSCoverity
extends SBSTask {
    private Vector<VariableSet> coverityOptions = new Vector();
    private Logger log = Logger.getLogger(SBSCoverity.class);
    private Date startTime;
    private Date endTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.validateParameter();
        this.setAddMakeOptions(false);
        CoverityErrorStreamConsumer coverityErrorConsumer = null;
        SBSCommandBase sbsCmd = new SBSCommandBase();
        sbsCmd.setWorkingDir(this.getWorkingDir());
        if (this.getCleanLog() != null) {
            sbsCmd.setCleanLogFilePath(this.getCleanLog());
        }
        try {
            this.log.debug((Object)("error stream file : " + this.getErrorOutput()));
            sbsCmd.addOutputLineHandler((StreamConsumer)new AntStreamConsumer((Task)this));
            if (this.getErrorOutput() == null) {
                this.log.debug((Object)"redirecting error to Antstream");
                sbsCmd.addErrorLineHandler((StreamConsumer)new AntStreamConsumer((Task)this));
            } else {
                coverityErrorConsumer = new CoverityErrorStreamConsumer(this.getErrorOutput());
                this.log.debug((Object)"redirecting error to file stream");
                sbsCmd.addErrorLineHandler((StreamConsumer)coverityErrorConsumer);
            }
        }
        catch (FileNotFoundException ex) {
            this.log.info((Object)("file path: " + this.getErrorOutput() + "Not valid"));
        }
        StringBuffer coverityCmdOptions = new StringBuffer();
        sbsCmd.setExecutable("cov-build");
        String coverityConfig = "";
        for (VariableSet coverityArg : this.coverityOptions) {
            for (Map.Entry entry : coverityArg.getVariablesMap().entrySet()) {
                coverityConfig = coverityConfig + (String)entry.getKey() + " " + ((Variable)entry.getValue()).getValue() + " ";
            }
        }
        coverityCmdOptions.append(coverityConfig + "sbs" + this.getSBSCmdLine());
        this.startTime = new Date();
        try {
            this.log("cov-build commands: " + coverityCmdOptions.toString());
            if (this.getExecute()) {
                sbsCmd.execute(coverityCmdOptions.toString());
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"Exception occured during 'cov-build' execution", (Throwable)ex);
            if (this.getFailOnError()) {
                throw new BuildException("exception during 'cov-build' execution", (Throwable)ex);
            }
        }
        finally {
            if (coverityErrorConsumer != null) {
                coverityErrorConsumer.close();
            }
        }
        this.endTime = new Date();
        this.updateSBSLogStatistics(this.getStatsLog(), this.getOutputLog(), this.startTime, this.endTime);
    }

    public void addCoverityOptions(VariableSet coverityArg) {
        if (!this.coverityOptions.contains(coverityArg)) {
            this.coverityOptions.add(coverityArg);
        }
    }
}

