/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.htmlcleaner.SpecialEntities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static String ltrim(String s) {
        if (s == null) {
            return null;
        }
        int index = 0;
        int len = s.length();
        while (index < len && Character.isWhitespace(s.charAt(index))) {
            ++index;
        }
        return index >= len ? "" : s.substring(index);
    }

    public static String rtrim(String s) {
        int len;
        if (s == null) {
            return null;
        }
        int index = len = s.length();
        while (index > 0 && Character.isWhitespace(s.charAt(index - 1))) {
            --index;
        }
        return index <= 0 ? "" : s.substring(0, index);
    }

    public static String ltrimNewline(String s) {
        if (s == null) {
            return null;
        }
        int index = 0;
        int len = s.length();
        while (index < len && Character.isWhitespace(s.charAt(index))) {
            if (s.charAt(index) == '\n') break;
            ++index;
        }
        return index >= len ? "" : s.substring(index);
    }

    public static StringBuffer readUrl(URL url, String charset) throws IOException {
        StringBuffer buffer = new StringBuffer(1024);
        Object content = url.getContent();
        if (content instanceof InputStream) {
            InputStreamReader reader = new InputStreamReader((InputStream)content, charset);
            char[] charArray = new char[1024];
            try {
                int charsRead = 0;
                do {
                    if ((charsRead = reader.read(charArray)) < 0) continue;
                    buffer.append(charArray, 0, charsRead);
                } while (charsRead > 0);
            }
            finally {
                reader.close();
            }
        }
        return buffer;
    }

    public static boolean isHexadecimalDigit(char ch) {
        return Character.isDigit(ch) || ch == 'A' || ch == 'a' || ch == 'B' || ch == 'b' || ch == 'C' || ch == 'c' || ch == 'D' || ch == 'd' || ch == 'E' || ch == 'e' || ch == 'F' || ch == 'f';
    }

    public static String escapeXml(String s, boolean advanced, boolean recognizeUnicodeChars, boolean translateSpecialEntities) {
        if (s != null) {
            int len = s.length();
            StringBuilder result = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                block34: {
                    char ch = s.charAt(i);
                    if (ch == '&') {
                        String entity;
                        Integer code;
                        String seq;
                        int semiIndex;
                        if (recognizeUnicodeChars && i < len - 1 && s.charAt(i + 1) == '#') {
                            int charIndex = i + 2;
                            String unicode = "";
                            while (charIndex < len && (Utils.isHexadecimalDigit(s.charAt(charIndex)) || s.charAt(charIndex) == 'x' || s.charAt(charIndex) == 'X')) {
                                unicode = String.valueOf(unicode) + s.charAt(charIndex);
                                ++charIndex;
                            }
                            if (charIndex == len || !"".equals(unicode)) {
                                try {
                                    char unicodeChar;
                                    char c = unicodeChar = unicode.toLowerCase().startsWith("x") ? (char)Integer.parseInt(unicode.substring(1), 16) : (char)Integer.parseInt(unicode);
                                    if ("&<>'\"".indexOf(unicodeChar) < 0) {
                                        int replaceChunkSize = charIndex < len && s.charAt(charIndex) == ';' ? unicode.length() + 1 : unicode.length();
                                        result.append(String.valueOf(unicodeChar));
                                        i += replaceChunkSize + 1;
                                        break block34;
                                    }
                                    i = charIndex;
                                    result.append("&#" + unicode + ";");
                                }
                                catch (NumberFormatException e) {
                                    i = charIndex;
                                    result.append("&amp;#" + unicode + ";");
                                }
                            } else {
                                result.append("&amp;");
                            }
                        } else if (translateSpecialEntities && (semiIndex = (seq = s.substring(i, i + Math.min(10, len - i))).indexOf(59)) > 0 && (code = (Integer)SpecialEntities.entities.get(entity = seq.substring(1, semiIndex))) != null) {
                            int entityLen = entity.length();
                            result.append("&#");
                            result.append(code);
                            result.append(";");
                            i += entityLen + 1;
                        } else if (advanced) {
                            String sub = s.substring(i);
                            if (sub.startsWith("&amp;")) {
                                result.append("&#38;");
                                i += 4;
                            } else if (sub.startsWith("&apos;")) {
                                result.append("&#39;");
                                i += 5;
                            } else if (sub.startsWith("&gt;")) {
                                result.append("&#62;");
                                i += 3;
                            } else if (sub.startsWith("&lt;")) {
                                result.append("&#60;");
                                i += 3;
                            } else if (sub.startsWith("&quot;")) {
                                result.append("&#34;");
                                i += 5;
                            } else {
                                result.append("&#38;");
                            }
                        } else {
                            result.append("&amp;");
                        }
                    } else if (ch == '\'') {
                        result.append("&#39;");
                    } else if (ch == '>') {
                        result.append("&#62;");
                    } else if (ch == '<') {
                        result.append("&#60;");
                    } else if (ch == '\"') {
                        result.append("&#34;");
                    } else {
                        result.append(ch);
                    }
                }
                ++i;
            }
            return result.toString();
        }
        return null;
    }

    public static String escapeXmlChars(String s) {
        if (s != null) {
            int len = s.length();
            StringBuilder result = new StringBuilder(len + 100);
            int i = 0;
            while (i < len) {
                char ch = s.charAt(i);
                if (ch == '\'') {
                    result.append("&apos;");
                } else if (ch == '>') {
                    result.append("&gt;");
                } else if (ch == '<') {
                    result.append("&lt;");
                } else if (ch == '\"') {
                    result.append("&quot;");
                } else {
                    result.append(ch);
                }
                ++i;
            }
            return result.toString();
        }
        return null;
    }

    public static void appendAmpersandEscapedAttribute(StringBuilder writer, String attributeName, Map<String, String> tagAtttributes) {
        String attributeValue = tagAtttributes.get(attributeName);
        if (attributeValue != null) {
            if (writer.length() > 0) {
                writer.append("&amp;");
            }
            writer.append(attributeName);
            writer.append("=");
            try {
                writer.append(URLEncoder.encode(attributeValue, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static void appendEscapedAttribute(Appendable writer, String attributeName, Map<String, String> tagAtttributes) throws IOException {
        String attributeValue = tagAtttributes.get(attributeName);
        if (attributeValue != null) {
            writer.append(Utils.escapeXml(attributeValue, false, false, false));
        }
    }

    public static int indexOfIgnoreCase(String searchableString, String startString, String endString, int fromIndex) {
        int n = endString.length();
        int len = startString.length();
        while (searchableString.length() > fromIndex + n - 1) {
            int index = searchableString.indexOf(startString, fromIndex);
            if (index >= 0 && searchableString.regionMatches(true, fromIndex = index + len, endString, 0, n)) {
                return fromIndex - len;
            }
            ++fromIndex;
        }
        return -1;
    }
}

