/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.deliver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.deliver.DeliverEngineSettings;
import org.apache.ivy.core.deliver.DeliverOptions;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.ConfigurationUtils;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public class DeliverEngine {
    private DeliverEngineSettings settings;

    public DeliverEngine(DeliverEngineSettings settings) {
        this.settings = settings;
    }

    public void deliver(String revision, String destIvyPattern, DeliverOptions options) throws IOException, ParseException {
        String resolveId = options.getResolveId();
        if (resolveId == null) {
            throw new IllegalArgumentException("A resolveId must be specified for delivering.");
        }
        File[] files = this.getCache().getConfigurationResolveReportsInCache(resolveId);
        if (files.length == 0) {
            throw new IllegalStateException("No previous resolve found for id '" + resolveId + "' Please resolve dependencies before delivering.");
        }
        XmlReportParser parser = new XmlReportParser();
        parser.parse(files[0]);
        ModuleRevisionId mrid = parser.getResolvedModule();
        this.deliver(mrid, revision, destIvyPattern, options);
    }

    private ResolutionCacheManager getCache() {
        return this.settings.getResolutionCacheManager();
    }

    public void deliver(ModuleRevisionId mrid, String revision, String destIvyPattern, DeliverOptions options) throws IOException, ParseException {
        Message.info(":: delivering :: " + mrid + " :: " + revision + " :: " + options.getStatus() + " :: " + options.getPubdate());
        Message.verbose("\toptions = " + options);
        long start = System.currentTimeMillis();
        destIvyPattern = this.settings.substitute(destIvyPattern);
        File ivyFile = this.getCache().getResolvedIvyFileInCache(mrid);
        if (!ivyFile.exists()) {
            throw new IllegalStateException("ivy file not found in cache for " + mrid + ": please resolve dependencies before delivering (" + ivyFile + ")");
        }
        ModuleDescriptor md = null;
        URL ivyFileURL = null;
        try {
            ivyFileURL = ivyFile.toURI().toURL();
            md = XmlModuleDescriptorParser.getInstance().parseDescriptor(this.settings, ivyFileURL, options.isValidate());
            md.setResolvedModuleRevisionId(ModuleRevisionId.newInstance(mrid, revision));
            md.setResolvedPublicationDate(options.getPubdate());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("malformed url obtained for file " + ivyFile, e);
        }
        catch (ParseException e) {
            throw new RuntimeException("bad ivy file in cache for " + mrid + ": please clean and resolve again", e);
        }
        HashMap<ModuleRevisionId, String> resolvedRevisions = new HashMap<ModuleRevisionId, String>();
        HashMap<ModuleRevisionId, String> dependenciesStatus = new HashMap<ModuleRevisionId, String>();
        File ivyProperties = this.getCache().getResolvedIvyPropertiesInCache(mrid);
        if (!ivyProperties.exists()) {
            throw new IllegalStateException("ivy properties not found in cache for " + mrid + ": please resolve dependencies before delivering (" + ivyFile + ")");
        }
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(ivyProperties);
        props.load(in);
        in.close();
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String depMridStr = (String)iter.next();
            String[] parts = props.getProperty(depMridStr).split(" ");
            ModuleRevisionId decodedMrid = ModuleRevisionId.decode(depMridStr);
            if (options.isResolveDynamicRevisions()) {
                resolvedRevisions.put(decodedMrid, parts[0]);
            }
            dependenciesStatus.put(decodedMrid, parts[1]);
        }
        HashMap<ModuleRevisionId, String> resolvedDependencies = new HashMap<ModuleRevisionId, String>();
        DependencyDescriptor[] dependencies = md.getDependencies();
        for (int i = 0; i < dependencies.length; ++i) {
            String rev = (String)resolvedRevisions.get(dependencies[i].getDependencyRevisionId());
            if (rev == null) {
                rev = dependencies[i].getDependencyRevisionId().getRevision();
            }
            String depStatus = (String)dependenciesStatus.get(dependencies[i].getDependencyRevisionId());
            resolvedDependencies.put(dependencies[i].getDependencyRevisionId(), options.getPdrResolver().resolve(md, options.getStatus(), ModuleRevisionId.newInstance(dependencies[i].getDependencyRevisionId(), rev), depStatus));
        }
        String publishedIvy = IvyPatternHelper.substitute(destIvyPattern, md.getResolvedModuleRevisionId());
        Message.info("\tdelivering ivy file to " + publishedIvy);
        String[] confs = ConfigurationUtils.replaceWildcards(options.getConfs(), md);
        HashSet<String> confsToRemove = new HashSet<String>(Arrays.asList(md.getConfigurationsNames()));
        confsToRemove.removeAll(Arrays.asList(confs));
        try {
            XmlModuleDescriptorUpdater.update((ParserSettings)this.settings, ivyFileURL, new File(publishedIvy), resolvedDependencies, options.getStatus(), revision, options.getPubdate(), null, true, confsToRemove.toArray(new String[confsToRemove.size()]));
        }
        catch (SAXException ex) {
            throw new RuntimeException("bad ivy file in cache for " + mrid + ": please clean and resolve again", ex);
        }
        Message.verbose("\tdeliver done (" + (System.currentTimeMillis() - start) + "ms)");
    }
}

