/* Get the system load averages.
   Copyright (C) 1985, 86, 87, 88, 89, 91, 92, 93, 1994, 1995, 1997
   	Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  */

/* Put the 1 minute, 5 minute and 15 minute load averages
   into the first NELEM elements of LOADAVG.
   Return the number written (never more than 3, but may be less than NELEM),
   or -1 if an error occurred.  */

extern int
getloadavg (double loadavg[],int nelem);

#include <make.h>
#include <pvm3.h>
#include "pvm_message.h"
#include <stdio.h>

void check_pvm_return(ret)
    int ret;
{
  if (ret >=0) return;
  switch (ret) {
  case PvmSysErr: printf("pvmd not responding (PvmSysErr)");
  case PvmNoHost: printf("Specified host is not in the virtual machine (PvmNoHost)");
  case PvmNoFile: printf("executable cannot be found (PvmNoFile)");
	default: printf("PVM error (%d)",ret);
  }
}

typedef struct {
  struct pvmhostinfo *ref;
  int tid;
	int loads;
	double avg[3];
} host_avg;

int compare (h1,h2) 
  const host_avg *h1;
  const host_avg *h2;
{
  int i;
  int loads = (h1->loads < h2->loads) ? h1->loads:h2->loads;
  for (i = 0 ; i< loads;i++) {
    if (h1->avg[i] < h2->avg[i]) return -1;
    if (h1->avg[i] > h2->avg[i]) return 1;
  }
	return 0;
}


int
main (argc, argv)
     int argc;
     char **argv;
{
  int naptime = 0;
  int mytid,ptid;
  mytid = pvm_mytid( );
  pvm_setopt(PvmAutoErr,0);
  check_pvm_return(mytid);
  ptid = pvm_parent();

  if (ptid == PvmNoParent) {
	  int i,ret;
    int nhosts = 0;
		int numhost = 0;
    int narchs = 0;
    int bufid;
    int size;
    int tid;
    int msgtag;
	
		host_avg *avg_table = NULL;
		struct pvmhostinfo *hostlist = 0;

	  pvm_config(&nhosts, &narchs, &hostlist);
		avg_table = (host_avg *) calloc(nhosts,sizeof(host_avg));
		if (avg_table==NULL) {
		  perror ("alloc avg_table");
			exit (-1);
		}
		
		for(i = 0; i < nhosts;i++) {
		    char *arg[2]={argv[1],NULL};
       ret = pvm_spawn( "loadavg", arg, PvmTaskHost, hostlist[i].hi_name, 1, &avg_table[i].tid );  
			check_pvm_return(ret); 
			if (ret == 1 ) {
			  pvm_notify( PvmTaskExit, pvmMakeChildDead, 1, &avg_table[i].tid );
			  numhost ++;	
			avg_table[i].ref = &hostlist[i];
			}

		}
		
		while (numhost) {
		  bufid = pvm_recv (-1, -1);
      if (bufid > 0 ) {
        pvm_bufinfo( bufid, &size, &msgtag,&tid );
        switch (msgtag) {
				case pvmMakeLoadAvg:
				  for (i = 0;i< nhosts;i++) if (tid == avg_table[i].tid) {
					  pvm_upkint(&avg_table[i].loads,1,1);
					  pvm_upkdouble(avg_table[i].avg,3,1);
					}
					break;
				case pvmMakeChildDead:
				  numhost -- ; 
					break;
			  }
  		}
		}
		qsort (avg_table,nhosts,sizeof(host_avg),compare);
		for (i = 0;i< nhosts;i++) if (avg_table[i].ref) {
		  printf("%-20s %2.2f:%2.2f:%2.2f\n",avg_table[i].ref->hi_name,
			                       avg_table[i].avg[0],
														 avg_table[i].avg[1],
 														 avg_table[i].avg[2]);
		}
  } else {
    double avg[3];
    int loads;
    if (argc > 1)
      naptime = atoi (argv[1]);
    while (1)
    {
      errno = 0;		/* Don't be misled if it doesn't set errno.  */
      loads = getloadavg (avg, 3);
      if (loads == -1)
	    {
	      perror ("Error getting load average");
	      exit (1);
	    }
		   pvm_initsend( PvmDataDefault );
       pvm_pkint(&loads,1,1);
       pvm_pkdouble(avg,3,1);
       pvm_send(ptid,pvmMakeLoadAvg);
       if (naptime == 0)
	       break;
       sleep (naptime);
	  }
	}
  pvm_exit( );
  exit (0);
}

