/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:31:43 $
 * $Revision: 1.23 $
 */
 
#ifndef _MSL_CTYPE_H
#define _MSL_CTYPE_H

#include <ansi_parms.h>

#if !_MSL_USING_MW_C_HEADERS
	#error You must have the non-MSL C header file access path before the MSL access path
#else

#include <cctype>

#if defined(__cplusplus) && defined(_MSL_USING_NAMESPACE)
	using std::isalnum;
	using std::isalpha;
#if   _MSL_C99 						/*- mm 030226 -*/
	using std::isblank;
#endif   /* _MSL_C99 */				/*- mm 030226 -*/
	using std::iscntrl;
	using std::isdigit;
	using std::isgraph;
	using std::islower;
	using std::isprint;
	using std::ispunct;
	using std::isspace;
	using std::isupper;
	using std::isxdigit;
	using std::tolower;
	using std::toupper;
#endif

#endif /* _MSL_USING_MW_C_HEADERS */

#endif /* _MSL_CTYPE_H */

/* Change record:
 * hh  971206 Created.
 * hh  991112 Fixed using bug.
 * JWW 001208 Added case for targeting Mach-O
 * JWW 011027 Use _MSL_USING_MW_C_HEADERS as generic header test instead of specific Mach-O test
 * mm  030226 Added _MSL_C99 wrappers for isblank()
 */