/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:31 $
 * $Revision: 1.17 $
 */
 
/*******************************************************************************/
/*  Project...: C++ and ANSI-C Compiler Environment                     ********/
/*  Purpose...: Interface functions to SIOUX for Windows			    ********/
/*******************************************************************************/

#ifndef _MSL_WINSIOUX_H
#define _MSL_WINSIOUX_H

#define _WINSIOUX 1
#include <ansi_parms.h>

_MSL_BEGIN_EXTERN_C

	typedef struct tSIOUXBuffer 
	{
		char	   *startpos,	/* pointer to a block of memory that will serve as the buffer  */
				   *curtop,     /* pointer to start of line at top of screen                   */
				   *endpos,		/* pointer to end of text in the buffer                        */
				   *inputstart,	/* pointer to a block of memory as keyboard input buffer       */
				   *inputcur,   /* pointer to next available character of input                */
				   *inputlast,  /* pointer to character after last input character             */
				   *SelBasePtr,	/* pointer to where selection began, may be start or end       */
				   *SelStartPtr,/* pointer to start of selected text						   */
				   *SelEndPtr;  /* pointer to end of selected text						   	   */
		int         WindowHeight,       /* Height of WinSIOUX console  */
		            WindowWidth;        /* Widtht of WinSIOUX console  */
		int			row, maxrow;/* row index of current insert point and max num of rows       */
		int			col, maxcol;/* column index of current insert point and max num of cols    */
		int         VscrollPos; /* Vert scroll button posn     */
		int         installed;  /* true if console has been installed                          */
		int         inputavail; /* true if input is available for program                      */
		int         dirtybit;   /* true if buffer changed since last saving                    */
		int         NeedInput; 	/* true if characters to be stored at caret position           */
		int         CmdShow;
		int         numlines;   /* Number of text lines in buffer                              */
		long        bufsize;    /* Current buffer size                                         */
	} tSIOUXBuffer;

	#define IDM_NEW				10
	#define IDM_OPEN			11
	#define IDM_CLOSE			12
	#define IDM_SAVE			13
	#define IDM_PRINT			14
	#define IDM_EXIT			15
	#define IDM_UNDO			16
	#define IDM_CUT				17
	#define IDM_COPY			18
	#define IDM_PASTE			19
	#define IDM_ALL				20

	#define _MAX_EXT_LEN   		 4

	#define EZ_ATTR_BOLD          1
	#define EZ_ATTR_ITALIC        2
	#define EZ_ATTR_UNDERLINE     4
	#define EZ_ATTR_STRIKEOUT     8

	typedef struct tSIOUXSettings 
	{
		char	initializeTB,			/* Initialize the ToolBox?                    TRUE   */
				standalone,				/* SIOUX running in standalone mode?          TRUE   */
				setupmenus,				/* Draw the SIOUX menus?                      TRUE   */
				autocloseonquit,		/* Close SIOUX window on program termination? FALSE  */
				asktosaveonclose,		/* Offer to save on a close?                  TRUE   */
				showstatusline;			/* Draw the status line?                      FALSE  */

		short	tabspaces,				/* Replace tabs with 'tabspaces' spaces       4      */
				columns,                /* Initial number of columns in window        80     */
				rows,					/* Initial number of rows in window           24     */
				toppixel,               /* Pixel posn of window on main screen         0     */
				leftpixel;				/* The topleft window position (in pixels)     0     */
										/* 	(0,0 centers on main screen)                     */
		char    fontname[32];           /*                                            courier*/
		short   fontsize,               /*                                            9      */   
				fontface;               /*                                            normal */   

	} tSIOUXSettings;

	extern tSIOUXSettings	SIOUXSettings;		/* SIOUX's settings structure ... */

	/*                                                      
	 *  void WinSIOUXclrscr(void);
	 *  Clear the WinSIOUX screen and empty the WinSIOUXBuffer.
	 */
	 
	_MSL_IMP_EXP_SIOUX void _MSL_CDECL WriteCharsToConsole(const char *, long) _MSL_CANT_THROW;						/*- mm 990423 -*/
	_MSL_IMP_EXP_SIOUX int _MSL_CDECL  ReadCharsFromConsole(void *, unsigned long, unsigned long*) _MSL_CANT_THROW;	/*- mm 990423 -*/
	_MSL_IMP_EXP_SIOUX void _MSL_CDECL WinSIOUXclrscr(void) _MSL_CANT_THROW;
	_MSL_IMP_EXP_SIOUX void _MSL_CDECL clrscr(void) _MSL_CANT_THROW;
	_MSL_IMP_EXP_SIOUX void _MSL_CDECL WinSIOUXAbort() _MSL_CANT_THROW;												/*- mm 981109 -*/

_MSL_END_EXTERN_C

#endif /* _MSL_WINSIOUX_H */

/* Change record:
 * mm  980411 Expanded to contain declaration of SIOUXBuffer structure
 * mm  980528 Added SIOUXBuffer.SelBasePtr to allow mouse selection both up and down.
 * mm  981106 Made clrscr() and WinSIOUXclrscr() visible in C++---WB1-2229
 * mm  981109 Added declaration of WinSIOUXAbort.
 * mm  990423 Added declarations for WriteCharsToConsole and ReadCharsFromConsole
 * mm  991217 Moved extern C to make SIOUXBuffer and SIOUXSettings visible in C++
 * cc  010410 updated to new namespace macros 
 * cc  011203 Added _MSL_CDECL for new name mangling 
 * hh  020603 Added no throw spec to functions
 */