/* Metrowerks x86 Runtime Support Library 
 * Copyright  1995-2003 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2005/02/25 15:03:06 $
 * $Revision: 1.1.2.1 $
 */

/*
--	is _m_pfrsqrt a composite?
--	allow old (instruction) named-intrinsics via macros
*/

/*
 *	3DNow! intrinsics API support.  
 *
 *	Culled from MSDN and web references.
 *
 *	Note, in Codewarrior, inline asm is as good as intrinsics
 *	so we implement the majority of functions as inlines.
 */

#ifndef _MM3DNOW_H
#define _MM3DNOW_H

#include <mmintrin.h>

#if __cplusplus
extern "C" {
#endif

#pragma volatile_asm off

#if 0
#pragma mark -	mm3dnow.h
#endif

float _m_to_float(__m64 m);
__m64 _m_from_float(float w);
__m64 _m_from_int(int i);

__inline void _m_femms(void)
{
	__asm femms
}

__inline __m64 _m_pavgusb(register __m64 a, register __m64 b)
{
	__asm PAVGUSB a,b;
	return a;
}

__inline __m64 _m_pf2id(register __m64 a)
{
	__asm PF2ID a,a;
	return a;
}

__inline __m64 _m_pf2iw(register __m64 a)
{
	__asm PF2IW a,a;
	return a;
}

__inline __m64 _m_pfacc(register __m64 a, register __m64 b)
{
	__asm PFACC a,b;
	return a;
}

__inline __m64 _m_pfcmpeq(register __m64 a, register __m64 b)
{
	__asm PFCMPEQ a,b;
	return a;
}

__inline __m64 _m_pfcmpge(register __m64 a, register __m64 b)
{
	__asm PFCMPGE a,b;
	return a;
}

__inline __m64 _m_pfcmpgt(register __m64 a, register __m64 b)
{
	__asm PFCMPGT a,b;
	return a;
}

__inline __m64 _m_pfmax(register __m64 a, register __m64 b)
{
	__asm PFMAX a,b;
	return a;
}

__inline __m64 _m_pfmin(register __m64 a, register __m64 b)
{
	__asm PFMIN a,b;
	return a;
}

__inline __m64 _m_pfmul(register __m64 a, register __m64 b)
{
	__asm PFMUL a,b;
	return a;
}

__inline __m64 _m_pfnacc(register __m64 a, register __m64 b)
{
	__asm PFNACC a,b;
	return a;
}

__inline __m64 _m_pfpnacc(register __m64 a, register __m64 b)
{
	__asm PFPNACC a,b;
	return a;
}

__inline __m64 _m_pfrcp(register __m64 a)
{
	__asm PFRCP a,a;
	return a;
}

__inline __m64 _m_pfrcpit1(register __m64 a, register __m64 b)
{
	__asm PFRCPIT1 a,b;
	return a;
}

__inline __m64 _m_pfrcpit2(register __m64 a, register __m64 b)
{
	__asm PFRCPIT2 a,b;
	return a;
}

__inline __m64 _m_pfrsqit1(register __m64 a, register __m64 b)
{
	__asm PFRSQIT1 a,b;
	return a;
}

__inline __m64 _m_pfrsqrt(register __m64 a)
{
	register __m64 r = a;
	__asm PFRSQRT r,a;
	return r;
}

__inline __m64 _m_pfsub(register __m64 a, register __m64 b)
{
	__asm PFSUB a,b;
	return a;
}

__inline __m64 _m_pfsubr(register __m64 a, register __m64 b)
{
	__asm PFSUBR a,b;
	return a;
}

__inline __m64 _m_pfi2d(register __m64 a)
{
	register __m64 r;
	__asm PI2FD r,a;
	return r;
}

__inline __m64 _m_pfi2w(register __m64 a)
{
	register __m64 r;
	__asm PI2FW r,a;
	return r;
}

__inline __m64 _m_pmulhrw(register __m64 a, register __m64 b)
{
	__asm PMULHRW a,b;
	return a;
}

__inline void _m_prefetch(register void* a)
{
	register void *p;
	__asm MOV p,a;
	__asm PREFETCH [p];
}

__inline void _m_prefetchw(register void* a)
{
	register void *p = (void *)a;
	__asm MOV p,a;
	__asm PREFETCHW [p];
}

__inline __m64 _m_pswapd(__m64 a)
{
	register __m64 r;
	__asm PSWAPD r,a;
	return r;
}

#pragma volatile_asm reset

#if __cplusplus
}
#endif

#endif	// _XMMINTRIN_H

/*
 * Change Log:
 * 030329 EJS	Initial checkin
 * 030605 EJS 	Use struct decls from original header instead of new keywords
 */
 