/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/05/07 17:10:35 $
 * $Revision: 1.10.2.1 $
 */
 
/*
 *	Content:	Interface file to standard UNIX-style entry points ...
 *
 *	NB:			This file implements some UNIX low level support.  These functions
 *				are not guaranteed to be 100% conformant.
 *
 */


#include <x86_prefix.h>
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <sys/stat.h>
#include <errno.h>
#include <crtl.h>
#include <extras.h>
#include <time_api.h>

/*
 *	int stat(char *path, struct stat *buf)
 *
 *		Returns information about a file.
 */
static mode_t __dostounixmode(int dosmodes, const char *path, HANDLE fhandle) _MSL_CANT_THROW;

int _MSL_CDECL stat(const char *path, struct stat *buf) _MSL_CANT_THROW
{
	int i;
	WIN32_FIND_DATA FileData;
	FILETIME times[3],loc_time;
	SYSTEMTIME sys_time;
	time_t *buf_times[3];
	struct tm tmp;
	HANDLE hFind = NULL;  /*- vss 990805 -*/
	
	
	/*  checks for valid filename, do NOT allow wildcard
        characters ? or * as FindFirstFile does allow.
        Also, if FindFirstFile fails the file could not be found,
        We fail here as well.
        
   */
     
	for(i=0;i<=strlen(path);i++)  
	{
		if(*(path+i)== 0x2a  || *(path+i)== 0x3F) 
		{
			errno=ENOENT; 
			return -1 ;
		}
	}
	
	/* FindFirstFile fails for root directories, we do this as a special case first
	   so we do the best we can */	
	   	 
	if(strlen(path) < 4 && path[1]==':' && (path[2]==0x5c || path[2]==0x2f))
	{
		DWORD SPC,BPS,FC,CPD ;
		if((buf->st_dev=(int)(tolower(path[0]) - 0x61) )< 0 )
		{ 
			errno=ENOENT;  
			return -1; 
		}
		if	(!GetDiskFreeSpace((LPCTSTR)path,&SPC,&BPS,&FC,&CPD)) 
			return -1;
		buf->st_size=(CPD-FC)*(BPS*SPC) ;  /* return # bytes allocated on entire drive */
		buf->st_mode=S_IFDIR|S_IREAD|S_IWRITE;
		buf->st_uid = buf->st_gid = buf->st_ino = buf->st_atime = buf->st_ctime = buf->st_ino = 0 ;
		return 0;
	}
 
     /* calculate drive letter ->  A=0,B=1, etc. ... */

	if(path[1] == 0x3a)
	{
		if((buf->st_dev=(int)(tolower(path[0]) - 0x61) )< 0 )
		{ 
			errno = ENOENT;  
			return -1; 
		}
	}			
	else 
	{ 
		buf->st_dev = (dev_t)(_getdrive() -1) ; 
	}  

	if((hFind = FindFirstFile((LPCTSTR)path,&FileData ))== INVALID_HANDLE_VALUE)  /*- vss 990805 -*/
	{ 
		errno = ENOENT;  
		return -1; 
	}  
			    
			    
    buf_times[0]=&(buf->st_atime);
    buf_times[1]=&(buf->st_mtime);
    buf_times[2]=&(buf->st_ctime); 
	times[0]=FileData.ftLastAccessTime;   
	times[1]=FileData.ftLastWriteTime;
 	times[2]=FileData.ftCreationTime;	 
	i=3;
	while(i)
	{
		i--;
		if(FileTimeToLocalFileTime(&times[i],&loc_time) &&
			    FileTimeToSystemTime(&loc_time,&sys_time))
		{
			tmp.tm_sec  = sys_time.wSecond;
	        tmp.tm_min  = sys_time.wMinute;       
	        tmp.tm_hour = sys_time.wHour;      /* hours since midnight */
	        tmp.tm_mday = sys_time.wDay;       /* day of month */
	        tmp.tm_mon  = sys_time.wMonth-1;   /* since January(0 for Jan.) */
	        tmp.tm_year = sys_time.wYear-1900; /* since 1900 */
	        tmp.tm_wday = sys_time.wDayOfWeek; /* since Sunday(0-6)*/
	            
	        if(!__msl_leap_year(tmp.tm_year))  
	        {
	        	tmp.tm_yday = __msl_month_to_days[1][tmp.tm_mon]; 
	        }
	        else
	        {
	        	tmp.tm_yday = __msl_month_to_days[2][tmp.tm_mon]; 
	        }
	                       					 /* days since jan. 1 */
	        tmp.tm_isdst    = __isdst();				/*- mm 010421 -*/
	        *(buf_times[i]) = mktime(&tmp);
	    }
	    else 
	    	buf_times[2] = buf_times[0];
	} /* end of while */
	            
	/* get size of file, can add support for files > 4GB if needed */
	buf->st_size=(off_t)FileData.nFileSizeLow;
	/* calculate mode */
	buf->st_mode = __dostounixmode(FileData.dwFileAttributes, path,NULL);          
	buf->st_nlink = 1 ;
			    
	/* unsupported or fields that make no sense on a Windows file/system */
	       
	buf->st_uid = buf->st_gid = buf->st_ino = 0;
	if (hFind)  
		FindClose(hFind);  /*- vss 990805 -*/
	return 0;			    		
} 
  
/*
 *	int fstat(int fildes, struct stat *buf)
 *
 *		Returns information about a file.
 */
 
int _MSL_CDECL fstat(int fildes, struct stat *buf) _MSL_CANT_THROW
{
    BY_HANDLE_FILE_INFORMATION FileData; 
    int i=0;
    FILETIME times[3],loc_time;
    SYSTEMTIME sys_time;
	time_t *buf_times[3];
	struct tm tmp;
	HANDLE h;

    if (!_HandleTable[fildes])
    { 
    	errno = ENOENT;  
    	return -1; 
    }
       
	h = _HandleTable[fildes]->handle;
	if(!GetFileInformationByHandle(h,&FileData) )
	{ 
		errno = ENOENT;  
		return -1; 
	}
			    
/* calculate mode first as this may be a device and not a file */
    buf->st_mode = __dostounixmode(FileData.dwFileAttributes, NULL,h);			    
    
    if(!(buf->st_mode & S_IFREG))  /* meaning either character special or pipe */
    {
		buf->st_dev = (_dev_t)fildes;
		buf->st_uid   = buf->st_gid = buf->st_ino = 0;
		buf->st_atime = buf->st_mtime = buf->st_ctime = 0;
		buf->st_nlink = FileData.nNumberOfLinks;/* 1 for FAT, >= 1 for NTFS */
		if ( buf->st_mode & S_IFCHR )
		{
			buf->st_size = 0;
		}
		else if( buf->st_mode & S_IFIFO )
		{
			unsigned long ulAvail;
			if(PeekNamedPipe(h,NULL,0,NULL,&ulAvail,NULL))           
				buf->st_size = (off_t)ulAvail;
			else 
				buf->st_size = 0;
		}
     	else 
		{ 
			errno=ENOENT;  
			return -1; 
		}
                
   		return 0;
   	}                
/* fildes represents a regular file(disk file)*/
     
	buf_times[0]=&(buf->st_atime);
	buf_times[1]=&(buf->st_mtime);
	buf_times[2]=&(buf->st_ctime);
	    	

/* calculate drive letter ->  A=0,B=1, etc. ... */
	
			    
	times[0]=FileData.ftLastAccessTime;   
	times[1]=FileData.ftLastWriteTime;
	times[2]=FileData.ftCreationTime;
			 
			 
	i=3;
	while(i)
	{
		i--;
		FileTimeToLocalFileTime(&times[i],&loc_time);
		FileTimeToSystemTime(&loc_time,&sys_time);
		tmp.tm_sec  = sys_time.wSecond;
		tmp.tm_min  = sys_time.wMinute;       
		tmp.tm_hour = sys_time.wHour;      /* hours since midnight */
		tmp.tm_mday = sys_time.wDay;       /* day of month */
		tmp.tm_mon  = sys_time.wMonth-1;   /* since January(0 for Jan.) */
		tmp.tm_year = sys_time.wYear-1900; /* since 1900 */
		tmp.tm_wday = sys_time.wDayOfWeek; /* since Sunday(0-6)*/

		if(!__msl_leap_year(tmp.tm_year))  
			tmp.tm_yday = __msl_month_to_days[1][tmp.tm_mon]; 
		else
			tmp.tm_yday = __msl_month_to_days[2][tmp.tm_mon]; 
		                             /* days since jan. 1 */
		tmp.tm_isdst = __isdst();							/*- mm 010421 -*/
		*(buf_times[i])=mktime(&tmp);
	}

	/* get size of file, can add support for files > 4GB as needed */
	         	            

	buf->st_size=(off_t)FileData.nFileSizeLow;


	buf->st_nlink = FileData.nNumberOfLinks;/* 1 for FAT, >= 1 for NTFS */
	/* unsupported or fields that make no sense on a Windows file system */
	buf->st_uid = buf->st_gid = buf->st_ino = 0;

	return 0;	
}


 
 /* 
    this function returns a st_mode as the exclusive or of the appropriate
    POSIX like(but not exactly posix) file mode macros defined in stat.h
 */
 
 /*******************************************************************************/
 
 mode_t __dostounixmode(int dosmodes, const char *path, HANDLE fhandle) _MSL_CANT_THROW
 {
	 mode_t  unixmodes=0 ;
	 char *p=(char*)path;  /* use later to determine whether or not a file is executable */
	 short extension=0;
	 if(p) extension=(short)(strlen(path) - 4);
	/* stat which is based on a path implies the file is a disk file so we don't need
	   to check for file type
	*/   

	if(fhandle)
	{
		switch(GetFileType(fhandle))
		{
			case FILE_TYPE_CHAR:
				unixmodes |= S_IFCHR ;
				break;
			
			case FILE_TYPE_PIPE:
				unixmodes |= S_IFIFO ;
				break;

			case FILE_TYPE_DISK:
			/* includes text or binary */
			/* is it a directory */
				(dosmodes & FILE_ATTRIBUTE_DIRECTORY ) ? (unixmodes |= (S_IFDIR | S_IEXEC) ) :
				                      (unixmodes |= S_IFREG) ;
				break;

			default:
			break;

		} 

	}
	else (dosmodes & FILE_ATTRIBUTE_DIRECTORY ) ? (unixmodes |= (S_IFDIR | S_IEXEC)) :
	                      (unixmodes |= S_IFREG) ;
	/* is it read only ?? */
	( dosmodes & FILE_ATTRIBUTE_READONLY )? (unixmodes |= S_IREAD) :
	                    (unixmodes |=(S_IREAD | S_IWRITE)) ;
		
				
	/* lastly determine whether the file is executable, there is no win api 
	that I know of that will determine this.  If you know a better way let us
	know.  Until then we base this on the extension of the file
	(.exe,.bat,.cmd,.com are the only ones considered executables) 
	*/
	if(extension > 0)
	{
		p+= extension;
		if (*p == '.' &&( strstr(p,".exe") || strstr(p,".cmd") || strstr(p,".bat") ||
		   																strstr(p,".com") )) 
			unixmodes |= S_IEXEC;

	}

	return unixmodes;
}           				
      				

/*
 *	int mkdir(const char *path)
 *
 */
int _MSL_CDECL mkdir(const char *path, ...) _MSL_CANT_THROW
{
	return CreateDirectory((LPCTSTR) path, NULL) ? 0 : -1;
}

/*
 *	int chmod (const char * __path, mode_t __pmode )
 *
 *		changes file-permissions
 */
 
int _MSL_CDECL chmod (const char * __path, mode_t __pmode ) _MSL_CANT_THROW
{

	WIN32_FIND_DATA FileData;
    HANDLE          hFile;
    
    if ((hFile = FindFirstFile(__path, &FileData)) == INVALID_HANDLE_VALUE) 
    {
		__set_errno(GetLastError());    
		return (-1);
    } 
    
    else 
    {
    	DWORD __fa;
   	
        __fa = GetFileAttributes(__path);
        
        if ( __pmode & S_IWRITE)
    	{
    	   __fa &= ~FILE_ATTRIBUTE_READONLY;
    	}
    	else
    	{	
    		__fa |= FILE_ATTRIBUTE_READONLY;
    		
    	}
    	
    	SetFileAttributes(__path, __fa);
    
 		return 0;
	}
}

/* Change record:
 * hh  980122 Replaced <windows.h> with the following TWO includes because it is seriously
 *            broken.  The following 2 includes must be carefully ordered as shown, because
 *            they are broken too.
 * hh  980122 commented out unused args
 * vss 990805 FindClose needs a handle, not a pointer to a struct
 * cc  000518 fixed #include 
 * cc  000707 added overrides
 * mm  010421 Corrected setting of tm_isdst 
 * cc  010918 Updated the include files
 * JWW 010927 Moved chmod from unix.win32.c to stat.win32.c
 * cc  020711 Added call to SetFileAttributes to save the new attributes (WB1-36873)
 * ejs 040108 Use <sys/stat.h>, not <stat.h>
 */