/* Metrowerks x86 Runtime Support Library 
 * Copyright  1995-2003 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/05/13 16:08:44 $
 * $Revision: 1.1 $
 */
 
#include <ansi_parms.h> 
#include <stddef.h>
#include <stdarg.h>
#include <stdlib.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include <crtl.h>
#include <ExceptionX86.h>
#include <ThreadLocalData.h>

extern int __cdecl main(int argc, char **argv, char **envp);
extern int __cdecl wmain(int argc, wchar_t **argv, wchar_t **envp);

int __cdecl _MWCHandler(
   	PEXCEPTION_RECORD exc, void */*exc_stack*/, LPCONTEXT context, void *mystery);       /* hh 971207 Added prototype */

extern int __cdecl _HandleUnexpectedSEHException(LPEXCEPTION_POINTERS exc);

// C++ exception tables

static ExceptionTableHeader ExceptionTables =
{
    &_PcToActionStart,
    &_PcToActionEnd,
    0
};


// The main entry point for Win32 console apps.

#if UNICODE
void __cdecl wmainCRTStartup();
void __cdecl wmainCRTStartup()
#else
void __cdecl mainCRTStartup();
void __cdecl mainCRTStartup()
#endif
{
	// register handler for uncaught SEH exceptions
	
	__try
	{
		// register handler for uncaught MS C++ exceptions

	    asm
	    {
			push	ebp
			mov		eax, -1
			push	eax
			push	eax
			push	OFFSET _MWCHandler
			mov 	eax, fs:[0]			// EJS 040413
			push	eax
			mov		fs:[0], esp
	    }
	
	    asm
	    {
			// align the stack
			sub		esp, 0x20
			and		esp, ~0x1f
	    }

		// Register the zero-overhead C++ exception handling tables

		_RegisterExceptionTables(&ExceptionTables);
		    
		// Perform library initialization

		if (!_CRTStartup())
			exit(-1);
		
		/* Setup the globals __argc and __argv. */
		_tSetupArgs();

		/* Get environment variables */
		_tSetupEnv();

		// Run the constructors for static and global C++ objects.

		_RunInit(&__xc_a);

		// Call the main program and exit with the status it returns

	#if UNICODE
		exit(wmain(__argc, __wargv, _wenviron));
	#else
		exit(main(__argc, __argv, _environ));
	#endif
	}
	__except (_HandleUnexpectedSEHException(GetExceptionInformation()))
	{
		abort();
	}
}

/* Change Record
 * hh  971207 Added main prototype
 * hh  971207 Added mainCRTStartup prototype
 * ejs 000320 Added unhandled exception filter
 * ejs 000819 Don't destroy thread data unless we're MSL
 * ejs 010123 Removed unhandled exception filter nonsense, added stack alignment
 * ejs 011023 Removed exception handler nonsense altogether
 * ejs 011119 Added "_environ" argument to main()
 * ejs 011206 Cleanup of init/term code
 * ejs 030721 Added UNICODE support via wmain()
 * ejs 040413 Change assembly code sequences to avoid crashing Purify
*/
