/* Metrowerks x86 Runtime Support Library 
 * Copyright  1995-2003 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2005/10/07 15:35:49 $
 * $Revision: 1.2 $
 */

#include <ansi_parms.h>
#include <TCHAR.H>
#include <stddef.h>
#include <stdarg.h>
#include <stdlib.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include <crtl.h>
#include <ExceptionX86.h>
#include <ThreadLocalData.h>
#include <abort_exit.h>

int
WINAPI
wWinMain(
    IN HINSTANCE hInstance,
    IN HINSTANCE hPrevInstance,
    IN LPWSTR lpCmdLine,
    IN int nShowCmd
    );

int __cdecl _MWCHandler(
   	PEXCEPTION_RECORD exc, void */*exc_stack*/, LPCONTEXT context, void *mystery);       /* hh 971207 Added prototype */

// C++ exception tables

static ExceptionTableHeader ExceptionTables =
{
    &_PcToActionStart,
    &_PcToActionEnd,
    0
};

extern int __cdecl _HandleUnexpectedSEHException(LPEXCEPTION_POINTERS exc);

// This is the real main entry point for Win32 GUI applications

#if UNICODE
void __cdecl wWinMainCRTStartup();
void __cdecl wWinMainCRTStartup()
#else
void __cdecl WinMainCRTStartup();
void __cdecl WinMainCRTStartup()
#endif
{
    STARTUPINFO si;
    int show;
    
	// register handler for uncaught SEH exceptions
	
	__try
	{
		// register handler for uncaught MS C++ exceptions

	    asm
	    {
			push	ebp
			mov		eax, -1
			push	eax
			push	eax
			push	OFFSET _MWCHandler
			mov		eax, fs:[0]		// EJS 040413
			push	eax
			mov		fs:[0], esp
	    }

		asm
		{
			// align the stack
			sub		esp, 0x20
			and		esp, ~0x1f
		}

	    // Register the exception C++ handling tables
	    
		_RegisterExceptionTables(&ExceptionTables);
	        
	    // Do C runtime library startup
		if (!_CRTStartup())
			exit(-1);
		
		/* Setup the globals __argc and __argv. */
		_tSetupArgs();

		/* Get environment variables */
		_tSetupEnv();
	    
		// Run the constructors for static and global C++ objects.
		_RunInit(&__xc_a);

	#if(__dest_os==__win32_os)  

		// Get the startup info for the show command

		GetStartupInfo(&si);
		if (si.dwFlags & STARTF_USESHOWWINDOW)
		{
		    show = si.wShowWindow;
		}
		else
		{
		    show = SW_SHOWDEFAULT;
		}

		// Call the WinMain and exit, passing command line (skip program name)

		exit(_tWinMain(GetModuleHandle(0), 0, _tcmdln + __argv1_offs, show));
				
	#else
	     exit(WinMain((void*)0x00400000/*(void*)GetCurrentProcessId()*/, 0, NULL, SW_SHOW));
	     /* why wince wants GetCurrentProcessId() I don't know,
	        MS says this will change, but this works for now */
	#endif
   }
   __except (_HandleUnexpectedSEHException(GetExceptionInformation()))
   {
		abort();
   }
}

/* Change Record
 * hh  971207 Added WinMainCRTStartup prototype
 * ejs 000320 Added unhandled exception filter
 * ejs 010123 removed unhandled exception filter nonsense, added stack alignment
 * ejs 011023 removed exception handler nonsense altogether
 * ejs 011119 Added call to _SetupEnv(), optimize command-line initialization
 * ejs 011206 Cleanup of init/term code
 * ejs 020406 Added handler for uncaught MS exceptions
 * ejs 030721 Added UNICODE support
 * ejs 040413 Change assembly code sequences to avoid crashing Purify
 */
