/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2005/02/01 23:52:51 $
 * $Revision: 1.59.2.2 $
 */

#ifndef _MSL_ANSI_PREFIX_WIN32_H
#define _MSL_ANSI_PREFIX_WIN32_H

#include <os_enum.h>
#define __dest_os __win32_os

#include <x86_prefix.h>

/*- ejs 030328 moved here from x86_prefix.h -*/
#ifndef _MSL_FALSE								/*- cc 010531 -*/
	#define _MSL_FALSE               0
#endif

#ifndef _MSL_TRUE								/*- cc 010531 -*/
	#define _MSL_TRUE                1
#endif

/* two macros for threading must be equal */
/* _MT is undefined or 1.  _MSL_THREADSAFE is 0 or 1. */
#ifndef _MSL_THREADSAFE
	#ifdef _MT
		/* _MT defined, use it */
		#define _MSL_THREADSAFE 1
	#else
		/* neither defined, use default config of "on" */
		#define _MSL_THREADSAFE 1
		#define _MT 1
	#endif
#else
	/* _MSL_THREADSAFE defined, use it */
	#if defined(_MT) && _MT != _MSL_THREADSAFE
		#error _MSL_THREADSAFE and _MT must match if set
	#else
		#if _MSL_THREADSAFE
			#define _MT 1
		#else
			#undef _MT	/* not #define _MT 0 ! */
		#endif
	#endif
#endif

/*	Make sure these are defined properly when using x86 CodeGen "Runtime" option */
#ifdef _DLL
	/*	EJS 030514 no longer needed
	#ifndef _MSL_NO_LOCALE
		#define _MSL_NO_LOCALE
	#endif
	*/
	#ifndef _MSL_IMP_EXP
		#define _MSL_IMP_EXP __declspec(dllimport)
	#endif
	
	#ifndef _MSL_DLL
		#define _MSL_DLL
	#endif
#endif

#if _MSL_THREADSAFE && !defined(_MSL_LOCALDATA)
	#define _MSL_LOCALDATA(_a) _GetThreadLocalData(_MSL_TRUE)->_a
#endif

#include <callingconv.win32.h>

#ifndef _MSL_POSIX
	#define _MSL_POSIX 1
#endif

#ifndef _MSL_C99
	#define _MSL_C99 1
#endif

#ifndef _MSL_LONGLONG
	#define _MSL_LONGLONG 1
#endif

#ifndef _MSL_WIDE_CHAR
	#define _MSL_WIDE_CHAR 1
#endif

#ifndef _MSL_FILE_CONSOLE_ROUTINES
	#define _MSL_FILE_CONSOLE_ROUTINES 1
#endif

#ifndef _MSL_WFILEIO_AVAILABLE
	#if defined(__MWERKS__) && __option(wchar_type)
		#define _MSL_WFILEIO_AVAILABLE 1
	#else
		#define _MSL_WFILEIO_AVAILABLE 0
	#endif
#endif

#ifndef _MSL_NEEDS_EXTRAS
	/* to access prototypes of non standard functions via a standard header */
	#define _MSL_NEEDS_EXTRAS 1
#endif

/* Variables used in ctime/time.h to set up CLOCKS_PER_SEC and clock_t */
#ifndef _MSL_CLOCKS_PER_SEC
	#define _MSL_CLOCKS_PER_SEC 1000
#endif

#ifndef _MSL_CLOCK_T
	#define _MSL_CLOCK_T long
#endif

#ifndef CLK_TCK
	#define CLK_TCK _MSL_CLOCKS_PER_SEC		
#endif

#ifndef _MSL_FLT_EVAL_METHOD
	#if defined(__MWERKS__) && __option(k63d)
	/*	K63D code tries to target MMX registers (method 0), 
		but certain interactions with double-precision or 
		x87-requiring code can force locals to x87 registers (method 2).
		Therefore overall the evaluation is indeterminable. */
		#define _MSL_FLT_EVAL_METHOD  -1
	#else
		#define _MSL_FLT_EVAL_METHOD  2		/* all long double */
	#endif
#endif

#define _MSL_INTEGRAL_MATH

#ifndef _MSL_MATH_ERRHANDLING
	#define _MSL_MATH_ERRHANDLING (MATH_ERRNO|MATH_ERREXCEPT)
#endif

/*
 * need this to pick up prototypes for _begin/_endthreadex 
 * in the win32 SDK header process.h
 */ 

#ifndef STOP_PROGRAM_BEFORE_EXIT
	/* will stop console apps from exiting before you get a chance to see it */
	/* set to 0 if you don't want this behavior */
	#define STOP_PROGRAM_BEFORE_EXIT 0
#endif

/* hh 980121 Protect ourselves from overly helpful Microsoft headers */
#define _WCHAR_T_DEFINED
#define _SIZE_T_DEFINED

/* #define _MSL_MALLOC_0_RETURNS_NON_NULL */


/*	Turn on _MSL_OS_DIRECT_MALLOC for a malloc alternative that simply goes
 *	straight to the OS with	no pooling.  Recompile the C lib when flipping
 *	this switch.  This will typically cause poorer performance, but may be of
 *	help when debugging memory problems. */

/* #define _MSL_OS_DIRECT_MALLOC */


/* #define _MSL_CLASSIC_MALLOC */

/*
 *	__ANSI_OVERLOAD__ controls whether or not the prototypes in the C++ standard
 *	section 26.5 get added to <cmath> and <math.h> or not.  If __ANSI_OVERLOAD__
 *	is defined, and a C++ compiler is used, then these functions are available,
 *	otherwise not.
 *	
 *	There is one exception to the above rule:  double abs(double); is available
 *	in <cmath> and <math.h> if the C++ compiler is used.  __ANSI_OVERLOAD__ has
 *	no effect on the availability of this one function.
 *	
 *	There is no need to recompile the C or C++ libs when this switch is flipped.
 */ /*- hh 980217 -*/ 

#define __ANSI_OVERLOAD__ 		/*- hh 990201 -*/

/* Turn on and off namespace std here */
#if defined(__cplusplus) && __embedded_cplusplus == 0
    #define _MSL_USING_NAMESPACE
	/* Turn on support for wchar_t as a built in type */
	/* #pragma wchar_type on */   /*  vss  not implemented yet  */
#endif

#include <wchar_t.h>

/*	If set, use #pragmas to direct the linker to add default
	libraries to the link, when the "Link with default libraries"
	option is enabled.  There is no harm in using these #pragmas
	if the option is disabled.  Even if the option is enabled,
	files in the project take precedence over these defaults. */
#ifndef _MSL_USE_DEFAULT_LIBS
	#if __option(link_default_libs)
		#define _MSL_USE_DEFAULT_LIBS 1
	#else
		#define _MSL_USE_DEFAULT_LIBS 0
	#endif
#endif

/* 	At this point we know enough to say what libraries will be needed. */
#ifndef _MSL_BUILDING_DLL
	#if _MSL_USE_DEFAULT_LIBS
		#if defined(__SYMBIAN__) || defined(__SYMBIAN32__) || defined(__WINSCW__)
			#include <defaultlibs.winscw.h>
		#else
			#include <defaultlibs.win32.h>
		#endif
	#endif	/*_MSL_USE_DEFAULT_LIBS*/
#endif	/*_MSL_BUILDING_DLL*/

#endif /* _MSL_ANSI_PREFIX_WIN32_H */

/* Change record:
 * KO  960711 Added this include for the WinNT headers
 * bkoz960829 need to define modena lib for c++ libraries
 * hh  980121 Protect ourselves from overly helpful Microsoft headers by telling them that
 *            we will take care of the C lib.
 * mf  980621 added #define _MWMT
 * hh  990201 turned __ANSI_OVERLOAD__ on because we now have foo(int) support
 * hh  990228 added _MSL_MALLOC_0_RETURNS_NON_NULL flag
 * mf  990301 yikes to the above ^, commented out STOP_PROGRAM_BEFORE_EXIT to attempt new scheme
 *            w/Pro 5 ide, also added logic for single threaded lib.
 * mf  990309 use _MWMT instead of _MT for single threaded lib
 * blc 990408 turned off STOP_PROGRAM_BEFORE_EXIT; not needed with Pro5 IDE
 * hh  000302 Moved the namespace flag to here from mslGlobals.h
 * cc  000315 added _MSL_IMP_EXP
 * cc  000316 removed  _MSL_IMP_EXP
 * JWW 010926 Turn on _MSL_POSIX get POSIX functions from ANSI headers
 * cc  011128 Added _MSL_CDECL and _MSL_TLS
 * ejs 011202 Added _MSL_USE_DEFAULT_LIBS and default library #pragmas.
 * JWW 020130 Changed _MWMT to _MSL_THREADSAFE for consistency's sake
 * ejs 020131 Guard against different _MT and _MSL_THREADSAFE
 * ejs 020131 More fixes: _MT must be undefined or 1, but _MSL_THREADSAFE is 0 or 1
 * ejs 020131 Always define _MSL_IMP_EXP and _MSL_NO_LOCALE if _DLL is on
 * ejs 020206 Move default library defs into defaultlibs.win32.h
 * hh  020214 Renamed _MSL_PRO4_MALLOC to _MSL_CLASSIC_MALLOC
 * ejs 020322 Force esoteric option combos to use __cdecl libraries
 * ejs 020420 Key _MSL_USE_DEFAULT_LIBS off pref panel setting
 * JWW 020604 Added _MSL_LOCALDATA macro definition to make multithread code easier to read
 * ejs 020604 Protect configurable feature macros with #ifndef
 * ejs 020801 Guard _MSL_MATH_ERRHANDLING with #ifndef
 * JWW 021010 Added wchar_t file I/O routines controlled by _MSL_WFILEIO_AVAILABLE
 * JWW 030224 Changed __MSL_LONGLONG_SUPPORT__ flag into the new more configurable _MSL_LONGLONG
 * JWW 030321 Configure __has_builtin macros for efficient x86 operations
 * ejs 030328 Moved _MSL_TRUE/_MSL_FALSE from x86_prefix.h
 * ejs 030329 ANSI-strict compatible __builtin___count_leading_zero
 * cc  030401 ANSI-keywords compatible __builtin___count_leading_zero
 * ejs 030514 Removing _MSL_NO_LOCALE since shared runtimes support it
 * ejs 030613 Remove __builtin_xxx now that compiler supports them
 * JWW 040405 Added new _MSL_FILE_CONSOLE_ROUTINES console configuration flag
 * ejs 050120 Define _MSL_DLL when building against DLL runtime
 * ejs 050201 Detect Symbian target correctly to include proper default libs
 */