/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.cruisecontrol.sourcecontrol;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.cruisecontrol.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModificationCache {
    private List<Modification> cache = new ArrayList<Modification>();

    public synchronized void add(Modification m) {
        this.cache.add(m);
    }

    public synchronized List<Modification> getModifications(Date lastBuild, Date now) {
        ArrayList<Modification> result = new ArrayList<Modification>();
        for (Modification m : this.cache) {
            if (!m.modifiedTime.after(lastBuild) || !m.modifiedTime.before(now)) continue;
            result.add(m);
        }
        return result;
    }

    public synchronized void cleanup(Date lastBuild) {
        ArrayList<Modification> result = new ArrayList<Modification>();
        for (Modification m : this.cache) {
            if (!m.modifiedTime.after(lastBuild)) continue;
            result.add(m);
        }
        this.cache = result;
    }
}

